<?php

$pixelId = '403981500659968';
$pixelToken = 'EAAEEZC486BHEBAC1Fpa0ZCQdevYuRxCVDqeqx0b4zkn1gtH2QZAYf6TDISrAUzI3SUdxSCeDAWNJFMs86eq4RV7RsZBMz5UUhiiCNFpuCkZA0gOzIpDyjKTxwByHKjRaT6ayHVcU7ntavEppF8JslkEKd5ewdWDdTAz4F3Aull8LD0WckyNGUroKbQ6l1NVcZD';
$url = 'https://graph.facebook.com/v11.0/' . $pixelId . '/events';


/* пример отправки конверсии
$res = sendPurchase('7999999338', 700);
$resDecode = json_decode($res);

if (isset($resDecode->error)) {
	echo 'ошибка отправки api conversion' . PHP_EOL;
}
*/


function initPurchaseData($phone, $price, $currency = 'RUB') {
  $event_time = time();
  $browser_id = uniqid();
  
  $event_id = '' . $browser_id . '_' . $event_time . '';

  setcookie('event_id_purchase', $event_id);

  $client_ip_address = getip();
  $client_user_agent = getUserAgent();
  
  $ph = hash('sha256', $phone);
  $event_source_url = getUrl();
  
  $data = array(
    [
      'event_id' => $event_id,
      'event_name' => 'Purchase',
      'event_time' => $event_time,
      'user_data' => [
        'ph' =>  $ph,
        'client_ip_address' => $client_ip_address,
        'client_user_agent' => $client_user_agent,
		'fbp' => isset($_COOKIE['_fbp']) ? $_COOKIE['_fbp'] : null,
		'fbc' => isset($_COOKIE['_fbc']) ? $_COOKIE['_fbc'] : null
      ],
      'custom_data' => [
        'currency' => $currency,
        'value' => $price
      ],
      'event_source_url' => $event_source_url,
      'action_source' => 'website'
    ]
  );
  return json_encode($data);
}


function curl_send(string $url, array $fields, string $method = 'POST') {
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

  if ($method == 'POST') {
    curl_setopt($ch, CURLOPT_POST, 1);
  }

  curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

  $output = curl_exec($ch);
  curl_close($ch);
  return $output;
}


function sendPurchase(string $phone, $price) {
  global $url, $pixelToken;
  
  $data = initPurchaseData($phone, $price);
  $fields = [
    'data' => $data,
    'access_token' => $pixelToken
  ];
  $result = curl_send($url, $fields);
  return $result;
}


function getip() {
	if (!isset($ipfound)) {
		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			$ipfound = $_SERVER['HTTP_CLIENT_IP'];
		}
	}

	if (!isset($ipfound)) {
		if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && !empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
      
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
			$ip = explode(", ", $ip);
			if (count($ip) <= 1) {
				$ip = explode(",", $ip[0]);
			}
			if (!empty($ip[0])) {
				$ipfound = $ip[0];
			}
		}
	}

	if (!isset($ipfound)) {
		if (isset($_SERVER['REMOTE_ADDR'])) {
			$ipfound = $_SERVER['REMOTE_ADDR'];
		}
	}

	if (!isset($ipfound)) {
		$ipfound = 'Unknown';
	}
  return $ipfound;
}

function getUserAgent() {
  $userAgent = 'Unknown';
  if (isset($_SERVER['HTTP_USER_AGENT'])) {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
  }
  return $userAgent;
}


function url(){
  if(isset($_SERVER['HTTPS'])) {
    $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http";
  } else {
    $protocol = 'http';
  }
  return $protocol . "://" . parse_url($_SERVER['REQUEST_URI'], PHP_URL_HOST);
}


function getUrl() {
  $currentPath = $_SERVER['PHP_SELF']; 
  $pathInfo = pathinfo($currentPath); 
  $hostName = $_SERVER['HTTP_HOST']; 
  $protocol = strtolower(substr($_SERVER["SERVER_PROTOCOL"],0,5))=='https'?'https':'http';
    
  // $dirname = $pathInfo['dirname'];
  // if ($dirname !== '/') {
  //   $dirname .= '/';
  // }

  return $protocol.'://'.$hostName.$currentPath;
}

?>
