$(document).ready(function() {

    /**
     * Фильтр каталога товаров
     */

    // получаем массив со всеми товарами каталога
    let productArray = [];
    $('#products .js-filter').each(function(i){
        let product = $(this).clone(true);
        productArray.push(product);
    });

    let filterArray = [];
    let fishArray = [];
    let weightArray = [];
    let stockArray = [];
    let fishWeightArray = [];
    let fishWeightStockArray = [];
    let fishStockArray = [];
    let weightStockArray = [];

    $('body').on('click', '.filter-nav__btn', function() {

        // очистим массив с результатами перед новой фильтрацией
        filterArray = [];

        $(this).toggleClass('filter-nav__btn_active');
        let countActive = $('.filter-nav__btn_active').length;

        if (!countActive) {
            $('#filter').hide();
            $('#products').show();
            return false;
        } else {
            $('#filter').show();
            $('#products').hide();
        }

        let activeFish = false;
        let activeWeight = false;
        let weightCount = 0;

        $('.filter-nav__btn_active').each(function(i) {

            let targetType = $(this).data('type');
            let targetValue = $(this).data('target');

            if (targetType == 'fish') {
                // если выбрано только по типу "рыба"
                // выборка идет с productArray

                // если это первый запрос, очистить массив с рыбой
                if (i == 0) {
                    fishArray = [];
                }
                activeFish = true;

                $.each(productArray, function(index, value) {
                    let dataBase = value.data('base');
                    let typeFish = dataBase.fish;
                    // если fish имеет несколько параметров
                    if (typeof dataBase.fish === 'object') {
                        $.each(dataBase.fish, function (ind, val) {
                            if (val == targetValue) {
                                fishArray.push(value);
                                return false;
                            }
                        });
                    } else {
                        if (typeFish == targetValue) {
                            fishArray.push(value);
                        }
                    }
                });

                filterArray = fishArray;

            } else if (targetType == 'weight' && activeFish == false) {
                // если выбрано только по типу "вес", при этом тип "рыба" не выбран
                // выборка идет с productArray

                // если это первый запрос, очистить массив с весом
                if (i == 0) {
                    weightArray = [];
                }
                activeWeight = true;

                $.each(productArray, function(index, value) {
                    let dataBase = value.data('base');
                    let typeWeight = dataBase.weight;
                    if (typeWeight == targetValue) {
                        weightArray.push(value);
                    }
                });

                filterArray = weightArray;

            } else if (targetType == 'stock' && activeFish == false && activeWeight == false) {
                // если выбрано только по типу "акция", при этом тип "рыба" и тип "вес" не выбран
                // выборка идет с productArray

                $.each(productArray, function(index, value) {
                    let dataBase = value.data('base');
                    if (dataBase.old_price) {
                        stockArray.push(value);
                    }
                });

                filterArray = stockArray;

            } else if (targetType == 'weight' && activeFish == true) {
                // если выбрано по типу "вес", когда тип "рыба" также выбран
                // выборка идет с fishArray

                activeWeight = true;

                // если это первый запрос из типа "вес", очистить массив с рыбой и весом
                if (weightCount == 0) {
                    fishWeightArray = [];
                }

                $.each(fishArray, function(index, value) {
                    let dataBase = value.data('base');
                    let typeWeight = dataBase.weight;
                    if (typeWeight == targetValue) {
                        fishWeightArray.push(value);
                    }
                });

                weightCount++;

                filterArray = fishWeightArray;

            } else if (targetType == 'stock' && activeFish == true && activeWeight == true) {
                // если выбрано по типу "акция", когда тип "рыба" и тип "вес" также выбран
                // выборка идет с fishWeightArray

                // так как у нас акция всего одна, всегда очищаем массив с акциями по рыбе и весу
                fishWeightStockArray = [];

                $.each(fishWeightArray, function(index, value) {
                    let dataBase = value.data('base');
                    if (dataBase.old_price) {
                        fishWeightStockArray.push(value);
                    }
                });

                filterArray = fishWeightStockArray;

            } else if (targetType == 'stock' && activeFish == true && activeWeight == false) {
                // если выбрано по типу "акция", когда тип "рыба" выбран, а тип "вес" не выбран
                // выборка идет с fishArray

                // так как у нас акция всего одна, всегда очищаем массив с акциями по рыбе
                fishStockArray = [];

                $.each(fishArray, function(index, value) {
                    let dataBase = value.data('base');
                    if (dataBase.old_price) {
                        fishStockArray.push(value);
                    }
                });

                filterArray = fishStockArray;

            } else if (targetType == 'stock' && activeFish == false && activeWeight == true) {
                // если выбрано по типу "акция", когда тип "рыба" не выбран, а тип "вес" выбран
                // выборка идет с weightArray

                // так как у нас акция всего одна, всегда очищаем массив с акциями по весу
                weightStockArray = [];

                $.each(weightArray, function(index, value) {
                    let dataBase = value.data('base');
                    if (dataBase.old_price) {
                        weightStockArray.push(value);
                    }
                });

                filterArray = weightStockArray;

            }

        });

        if (filterArray.length) {
            $.each(filterArray, function(index, value) {
                if (index == 0) {
                    $('#filter .filter-product').html('');
                }
                $('#filter .filter-product').append(value);
            });
        } else {
            $('#filter .filter-product').html('<div class="filter-product__empty">По заданным параметрам ничего не найдено.</div>');
        }

    });

});