<?php
$meta_title = 'Черная икра с доставкой по РФ от Егора Осетрова';
$meta_description = ''; // можно оставить пустым
$canonical = ''; // можно оставить пустым
$theme = 'dark'; // dark или light
$popup_rf = true; // показывать текст в попапе заказа для РФ
$filter = true;

require_once 'parts/header.php';
?>

    <div class="welcome">
        <div class="container welcome__container">

            <?php require 'parts/header-inner.php'; ?>

            <?php
                $welcome_product = [
                    'name' => 'Икра черная "Премиум"',
                    'weight' => 250,
                    'price' => 11990,
                    'old_price' => 13990,
                    'desc' => '<b>Состав:</b> икра осетра, соль.',
                    'label' => '',
                    'img' => '',
                    'gallery' => [
                        '/img/product/430x330/prem250.jpg',
                        '/img/product/430x330/prem1.jpg',
                        '/img/product/430x330/prem2.jpg',
                        '/img/product/430x330/prem3.jpg',
                        '/img/product/430x330/prem4.jpg',
                        '/img/product/430x330/sert1.jpg',
                        '/img/product/430x330/sert2.jpg',
                    ],
                    'review' => [
                        '/img/reviews/premium1.jpg',
                        '/img/reviews/premium2.jpg',
                        '/img/reviews/premium3.jpg',
                        '/img/reviews/premium4.jpg',
                        '/img/reviews/premium5.jpg',
                    ],
                ];
            ?>

            <div class="dark-welcome dark-welcome_home" data-base='<?= json_encode($welcome_product) ?>'>
                <h1 class="dark-welcome__title">Фермерская черная икра с доставкой по РФ</h1>
                <div class="dark-welcome__row">
                    <div class="dark-welcome__img">
                        <div class="dark-welcome__img-inner">
                            <img src="/img/welcome/img-welcome-premium250.png" width="782" height="547" alt="">
                        </div>
                    </div>
                    <div class="dark-welcome__about">
                        <div class="dark-welcome__name">Черная икра осетра Премиум 250г</div>
                        <div class="dark-welcome__desc">По специальной цене</div>
                        <div class="dark-welcome__price">
                            <div class="dark-welcome__price-current">11 990 ₽</div>
                            <div class="dark-welcome__price-old">13 990 ₽</div>
                        </div>
                        <div class="dark-welcome__action">
                            <div class="dark-welcome__btn btn js-buy">Заказать со скидкой</div>
                            <div class="dark-welcome__date">Только до <?= get_future_date('next sunday') ?></div>
                        </div>
                    </div>
                </div>
                <div class="dark-welcome__advant">
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-map"/></svg>
                        <div class="dark-welcome__advant-title">Прямые поставки <br>из Астрахани</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-delivery"/></svg>
                        <div class="dark-welcome__advant-title">Бесплатная <br>доставка во множество городов</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-menu-01"/></svg>
                        <div class="dark-welcome__advant-title">Без <br>консервантов</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-caviar"/></svg>
                        <div class="dark-welcome__advant-title">Настоящий <br>малосол</div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="product-wrap">
        <div class="container">

            <?php require 'parts/city.php'; ?>

            <div class="product-head" id="catalog">
                <div class="product-head__label">Широкий ассортимент</div>
                <div class="product-head__title">Фермерская икра</div>
            </div>

            <?php if (isset($filter) && $filter) { require 'parts/filter.php'; } ?>

            <div id="products">
                <?php require 'parts/product-classic.php'; ?>
                <?php require 'parts/product-premium.php'; ?>
                <?php require 'parts/product-otbor.php'; ?>
                <?php require 'parts/product-carskaya.php'; ?>
                <?php require 'parts/product-royal.php'; ?>
                <?php require 'parts/product-paus.php'; ?>
                <?php require 'parts/product-royalpaus.php'; ?>
                <?php require 'parts/product-delicacy.php'; ?>
            </div>

        </div>
    </div>

<?php require 'parts/about.php'; ?>
<?php require 'parts/why.php'; ?>

<div class="bg-wrap">
    <div class="container">
        <?php require 'parts/review.php'; ?>
        <?php require 'parts/video.php'; ?>
    </div>
</div>

<?php require 'parts/certificate.php'; ?>
<?php require 'parts/delivery-rf.php'; ?>

<?php require_once 'parts/footer.php'; ?>