<?php

define("API_LINK", "https://online.moysklad.ru/api/remap/1.1");

define("API_USER", "admin@egorpanteleev2");

define("API_PASS", "Egor1987@");

define("API_LINK_MANAGERS", "https://online.moysklad.ru/api/remap/1.1/entity/employee");

define("API_LINK_STATUSES", "https://online.moysklad.ru/api/remap/1.1/entity/customerorder/metadata");

define("API_FILDS_CONTACT", "https://online.moysklad.ru/api/remap/1.1/entity/counterparty/metadata");

define("LINK_COUNTERPARTY", "/entity/counterparty");

define("LINK_CUSTOMERORDER", "/entity/customerorder");

define("LINK_RETAILDEMAND", "/entity/retaildemand");

define("LINK_COMMISSIONERREPORTOUT", "/entity/commissionreportout");

define("LINK_COMMISSIONERREPORTIN", "/entity/commissionreportin");

class Helper

{

    private $limit;

    private $offset;

    private $edit_date;

    private $completed_statuses_list;

    public $total;

    private $fields;

    private $manager = array();

    public function __construct($limit = 0, $offset = 0, $edit_date = '')
    {
        $this->limit = $limit;

        $this->offset = $offset;

        $this->edit_date = $edit_date;

        $this->fields = $this->getFields();
    }

    public function getFields()
    {
        $fields       = array();
        $fields_order = self::curlByLink(API_LINK_STATUSES);
        foreach ($fields_order['attributes'] as $field) {
            $fields[] = array(
                'id'   => $field['id'],
                'name' => $field['name'],
            );
        }

        return $fields;
    }

    private function isCompleted($status_id)
    {

        return in_array($status_id, $this->completed_statuses_list);

    }

    public function getPrimeCost($id)
    {

        $result = array(

            "cost" => 0,

            "profit" => 0,

        );

        $order      = self::curl(LINK_RETAILDEMAND, $id);
        $time_begin = new DateTime($order['moment']);

        $time_begin->modify("-1 minute");

        $time_begin = $time_begin->format("Y-m-d H:i:s");

        $time_end = new DateTime($order['moment']);

        $time_end->modify("+1 minute");

        $time_end = $time_end->format("Y-m-d H:i:s");

        $positions = self::curl("/entity/retaildemand/{$id}/positions");
        foreach ($positions['rows'] as $position) {

            $id = self::parse($position['assortment']['meta']['href']);

            $filter = "filter=product.id={$id}&momentFrom=".urlencode($time_begin)."&momentTo=".urlencode($time_end);

            $report = self::curlByLink('report/profit/byproduct?'.$filter);

            $report_position = isset($report['rows'][0]) ? $report['rows'][0] : null;

            if ($report_position) {

                $result['cost'] += $report_position['sellCost'];

                $result['profit'] += $report_position['sellPrice'] - $report_position['sellCost'];

            }

        }

        return $result;

    }

    public function getCustomeCost($id)
    {
        $result    = array(
            "cost" => 0,
        );
        $positions = self::curl('/entity/customerorder/', $id.'/positions');
        foreach ($positions['rows'] as $position) {
            $col        = $position['quantity'];
            $id         = self::parse($position['assortment']['meta']['href']);
            $tovar      = self::curl('/entity/product/', $id);
            $cost_price = isset($tovar['buyPrice']['value']) ? $tovar['buyPrice']['value'] : 0;
            if ($cost_price) {
                $result['cost'] += $cost_price * $col;
            }

        }

        return $result;
    }

    public function getOrders()
    {
        $result = array();
        $orders = self::initCustomerOrder();
        $last   = count($orders) > $this->limit + $this->offset ? $this->limit + $this->offset : count($orders);
        for ($i = 0;$i < $last;$i++) {

            $cost = 0;

            if ($orders[$i]['is_retail']) {
                $costs = self::getCustomeCost($orders[$i]['id']);
                $cost  = $costs['cost'] / 100;
            }
            $orders[$i]['cost'] = $cost;

            $orders[$i]['fields']['cost'] = $cost;

            $result[] = $orders[$i];

        }

        return $result;
    }

    public function getStates()
    {

        $result       = array();
        $states_sales = self::curlByLink(API_LINK_STATUSES);
        foreach ($states_sales['states'] as $state) {

            $result[] = array(

                'id' => $state['id'],

                'name' => $state['name'],

            );

        }

        return $result;

    }


    // Получение доп.полей пользователя
    public function getMetaClient()
    {
        $contact_meta = self::curlByLink(API_FILDS_CONTACT);
        $fields       = array();
        foreach ($contact_meta['attributes'] as $field) {
            $fields[] = array(
                'id'   => $field['id'],
                'name' => $field['name'],
            );
        }

        return $contact_meta['attributes'];
    }

    // Получение доп.полей Сделки
    public function getMetaLead()
    {
        $lead_meta = self::curlByLink('https://online.moysklad.ru/api/remap/1.1/entity/customerorder/metadata');
        $fields    = array();
        foreach ($lead_meta['attributes'] as $field) {
            $fields[] = array(
                'id'   => $field['id'],
                'name' => $field['name'],
            );
        }

        return $fields;
    }

    public function getClients()
    {

        $result = array();
        $contacts = self::getContacts();

        foreach ($contacts as $contact) {
            $update_date = date('U', strtotime($contact['updated']));
            if ($update_date < $this->edit_date) {
                continue;
            }

            $result[] = array(
                'id'    => $contact['id'],
                'name'  => $contact['name'],
                'phone' => isset($contact['phone']) ? $contact['phone'] : "",
                'email' => isset($contact['email']) ? $contact['email'] : "",

            );

        }

        return $result;

    }

    public function getSales($offset_sale, $limit = 600)
    {

        $result   = array();
        $response = self::curl(LINK_CUSTOMERORDER, "", 100, $offset_sale, "updated,asc", $this->edit_date);

        if ($response['rows']) {
            $result = $response['rows'];
        }

        return $result;

    }

    public function getRetails($offset_retail, $limit)
    {

        $result = array();


        $response = self::curl(LINK_RETAILDEMAND, "", 100, $offset_retail, "created,desc", $this->edit_date);
        if ($response['rows']) {
            $result = $response['rows'];
        }

        $loc_offset = 100;

        for ($i = 0;$i < 5;$i++) {
            if (isset($response['meta']['nextHref'])) {
                $response = self::curl(LINK_RETAILDEMAND, "", 100, $offset_retail + $loc_offset, "created,desc",
                    $this->edit_date);
                if ($response['rows']) {
                    $result = self::arrayMerge($response['rows'], $result);
                }
                $loc_offset += 100;
            }
        }

        return $result;

    }

    public function getCommissionerReportIn($offset_cr, $limit = 300)
    {

        $result = array();

        $response = self::curl(LINK_COMMISSIONERREPORTIN, "", 100, $offset_cr, "created,desc", $this->edit_date);

        if ($response['rows']) {
            $result = $response['rows'];
        }

        $loc_offset = 100;

        for ($i = 0;$i < 5;$i++) {
            if (isset($response['meta']['nextHref'])) {
                $response = self::curl(LINK_COMMISSIONERREPORTIN, "", 100, $offset_cr + $loc_offset, "created,desc",
                    $this->edit_date);
                if ($response['rows']) {
                    $result = self::arrayMerge($response['rows'], $result);
                }
                $loc_offset += 100;
            }
        }

        return $result;

    }

    public function getCommissionerReportOut($offset_cr, $limit = 300)
    {

        $result = array();

        $response = self::curl(LINK_COMMISSIONERREPORTOUT, "", 100, $offset_cr, "created,desc", $this->edit_date);

        if ($response['rows']) {
            $result = $response['rows'];
        }

        $loc_offset = 100;

        for ($i = 0;$i < 5;$i++) {
            if (isset($response['meta']['nextHref'])) {
                $response = self::curl(LINK_COMMISSIONERREPORTOUT, "", 100, $offset_cr + $loc_offset, "created,desc",
                    $this->edit_date);
                if ($response['rows']) {
                    $result = self::arrayMerge($response['rows'], $result);
                }
                $loc_offset += 100;
            }
        }

        return $result;

    }

    private function getContacts()
    {

        $result = array();

        $limit = 10000;

        $total = 0;

        $thrs = 5;

        $lim = $this->limit < 100 ? $this->limit : 100;

        $response = self::curl(LINK_COUNTERPARTY, "", $lim, $this->offset, "created,desc", $this->edit_date);

        if ($response['rows']) {

            $result = $response['rows'];

            $total = $response['meta']['size'];

        }

        if ($this->total < $total) {
            $this->total = $total;
        }

        if (count($result) >= $limit || (count($result) + $this->offset) >= $total) {
            return $result;
        }

        $loc_offset = 100;

        while (count($result) < $total) {

            $response = self::multiCurl(LINK_COUNTERPARTY, 100, $this->offset + $loc_offset, "created,desc",
                $this->edit_date, $thrs);

            $result = self::arrayMerge($response, $result);

            if (count($result) >= $limit || (count($result) + $this->offset) >= $total) {
                return $result;
            }

            $loc_offset += $thrs * 100;

        }

        return $result;

    }

    public function getOrdersCount()
    {

        $result = 0;

        $response = self::curl(LINK_CUSTOMERORDER, "", 1, 0, "updated,asc", $this->edit_date);

        if ($response['rows']) {

            $result += $response['meta']['size'];

        }

        return $result;

    }

    public function init()
    {
        $result     = 0;
        $orders     = array();
        $limit_tmp  = $this->limit;
        $offset_tmp = $this->offset;
        $limit      = 600;
        $offset     = 600 * ($offset_tmp / $limit_tmp);
        $sales      = self::getSales($offset, $limit);
        $retails    = self::getRetails($offset, $limit);

        $cr_in  = self::getCommissionerReportIn($offset, $limit);
        $cr_out = self::getCommissionerReportOut($offset, $limit);
        if (count($sales) == 0 && count($retails) == 0 && count($cr_in) == 0 & count($cr_out) == 0) {
            return;
        }

        foreach ($sales as $sale) {
            if (isset($sale['demands'])) {
                foreach ($sale['demands'] as $dep) {
                    if (substr_count($dep['meta']['href'], 'entity/retaildemand') > 0) {
                        $dependent_ids[] = self::parse($dep['meta']['href']);
                    }
                }
            }
            $roistat = "";
            $fields  = array();
            if (isset($sale['attributes'])) {
                foreach ($sale['attributes'] as $field) {
                    if ($field['name'] == 'roistat') {
                        $roistat = $field['value'];
                    }
                    $fields["{$field['name']}"] = $field['value'];
                }
            }

            if (isset($sale['agent']['meta']['href'])) {
                $agent = self::parse($sale['agent']['meta']['href']);
            }
            $state = "unknown/retail";

            if (isset($sale['state']['meta']['href'])) {
                $state = self::parse($sale['state']['meta']['href']);
            }

            $cost = 0;

            $orders[] = array(
                "id"          => $sale['id'],
                "name"        => $sale['name'],
                "date_create" => date('U', strtotime($sale['moment'])),
                //"date_create"   => date('U',strtotime($sale['updated'])),
                "date_update" => date('U', strtotime($sale['updated'])),
                "status"      => $state,
                "price"       => $sale['sum'] / 100,
                "cost"        => $cost,
                "roistat"     => $roistat,
                "client_id"   => $agent,
                "is_retail"   => false,
                "fields"      => $fields,
            );
        }

        foreach ($retails as $retail) {
            // if (in_array($retail['id'],$dependent_ids)){continue;}
            $roistat = "";
            if (isset($retail['description'])) {
                $descr = self::transliterate($retail['description']);
                if (substr_count(strtolower($descr), "samovyvoz")) {
                    continue;
                }
                $roistat = $descr;
            }
            $form = "";
            if (isset($retail['attributes'])) {
                $form = self::getForm($retail['attributes']);
            }
            $state = "took_away";
            if (isset($retail['state']['meta']['href'])) {
                $state = self::parse($retail['state']['meta']['href']);
            }
            $cost     = 0;
            $orders[] = array(
                "id"          => $retail['id'],
                "name"        => $retail['name'],
                "date_create" => date('U', strtotime($retail['moment'])),
                "date_update" => date('U', strtotime($retail['updated'])),
                "status"      => $state,
                "price"       => $retail['sum'] / 100,
                "cost"        => $cost,
                "roistat"     => $roistat,
                "client_id"   => $retail['id'],
                "is_retail"   => true,
                "fields"      => array(
                    "form" => $form,
                ),
            );
            $result++;
        }

        foreach ($cr_in as $item) {
            $roistat = "";
            if (isset($item['attributes'])) {
                $roistat = self::getVisit2($item['attributes']);
            }
            $agent = "";
            if (isset($sale['agent']['meta']['href'])) {
                $agent = self::parse($sale['agent']['meta']['href']);
            }
            $form = "";
            if (isset($retail['attributes'])) {
                $form = self::getForm($retail['attributes']);
            }
            $orders[] = array(
                "id"          => $item['id'],
                "name"        => $item['name'],
                "date_create" => date('U', strtotime($item['moment'])),
                "date_update" => date('U', strtotime($item['updated'])),
                "status"      => "commissioner_report_in",
                "price"       => $item['sum'] / 100,
                "cost"        => 0,
                "roistat"     => $roistat,
                "client_id"   => $agent,
                "is_retail"   => false,
                "fields"      => array(
                    "form" => $form,
                ),
            );
            $result++;
        }
        foreach ($cr_out as $item) {
            $roistat = "";
            if (isset($item['attributes'])) {
                $roistat = self::getValue('roistat', $sale['attributes']);
            }
            $agent = "";
            if (isset($sale['agent']['meta']['href'])) {
                $agent = self::parse($sale['agent']['meta']['href']);
            }
            $form = "";
            if (isset($retail['attributes'])) {
                $form = self::getForm($retail['attributes']);
            }
            $orders[] = array(
                "id"          => $item['id'],
                "name"        => $item['name'],
                "date_create" => date('U', strtotime($item['moment'])),
                "date_update" => date('U', strtotime($item['updated'])),
                "status"      => "commissioner_report_out",
                "price"       => $item['sum'] / 100,
                "cost"        => 0,
                "roistat"     => $roistat,
                "client_id"   => $agent,
                "is_retail"   => false,
                "fields"      => array(
                    "form" => $form,
                ),
            );
            $result++;
        }
        $this->limit  = $limit_tmp;
        $this->offset = $offset_tmp;

        return $orders;

    }

    public function initCustomerOrder()
    {
        $orders = array();
        $sales = self::getSales($this->offset, $this->limit);
        if (count($sales) == 0) {
            return;
        }
        foreach ($sales as $sale) {
            if (isset($sale['demands'])) {
                foreach ($sale['demands'] as $dep) {
                    if (substr_count($dep['meta']['href'], 'entity/retaildemand') > 0) {
                        $dependent_ids[] = self::parse($dep['meta']['href']);
                    }
                }
            }
            $roistat = "";
            $fields  = array();
            if (isset($sale['attributes'])) {
                foreach ($sale['attributes'] as $field) {
                    if ($field['name'] == 'roistat') {
                        $roistat = $field['value'];
                    }
                    $fields["{$field['name']}"] = $field['value'];
                }
            }
            $agent = "";
            if (isset($sale['agent']['meta']['href'])) {
                $agent                = self::parse($sale['agent']['meta']['href']);
                $fields['clients_id'] = $agent;
            }
            $state = "unknown/retail";

            if (isset($sale['state']['meta']['href'])) {
                $state = self::parse($sale['state']['meta']['href']);
            }

            $cost = 0;

            $orders[] = array(
                "id"          => $sale['id'],
                "name"        => $sale['name'],
                "date_create" => date('U', strtotime($sale['moment'])),
                //"date_create"   => date('U',strtotime($sale['updated'])),
                "date_update" => date('U', strtotime($sale['updated'])),
                "status"      => $state,
                "price"       => $sale['sum'] / 100,
                "cost"        => $cost,
                "roistat"     => $roistat,
                "client_id"   => $agent,
                "is_retail"   => true,
                "fields"      => $fields,
            );
        }
        return $orders;

    }

    private function getVisit($arr)
    {

        foreach ($arr as $item) {

            if ($item['id'] == FIELD_ID_VISIT) {

                return $item['value'];

            }

        }

        return "";

    }

    private function getValue($string, $fields)
    {
        foreach ($fields as $field) {
            if ($field['name'] == $string) {
                return $field['value'];
            }
        }

        return '';
    }

    private function getVisit2($arr)
    {

        foreach ($arr as $item) {

            if ($item['id'] == "09df2bae-0774-11e9-9ff4-34e8000fcb7d") {

                return $item['value'];

            }

        }

        return "";

    }

    private function getForm($arr)
    {

        foreach ($arr as $item) {

            if ($item['id'] == FIELD_ID_FORM) {

                return $item['value'];

            }

        }

        return "";

    }

    private function getCancelReason($arr)
    {

        foreach ($arr as $item) {

            if ($item['id'] == FIELD_ID_CANCEL_REASON) {

                return $item['value'];

            }

        }

        return "";

    }

    public function getManagers()
    {

        $result = array();

        $response = self::curlByLink(API_LINK_MANAGERS);

        foreach ($response['rows'] as $row) {

            $result[$row['id']] = $row['name'];

        }

        return $result;

    }

    public function parse($href)
    {

        $href = strrev($href);

        $id = mb_stristr($href, "/", true);

        return trim(strrev($id));

    }

    private function transliterate($str)
    {

        $rus = array(
            'А',
            'Б',
            'В',
            'Г',
            'Д',
            'Е',
            'Ё',
            'Ж',
            'З',
            'И',
            'Й',
            'К',
            'Л',
            'М',
            'Н',
            'О',
            'П',
            'Р',
            'С',
            'Т',
            'У',
            'Ф',
            'Х',
            'Ц',
            'Ч',
            'Ш',
            'Щ',
            'Ъ',
            'Ы',
            'Ь',
            'Э',
            'Ю',
            'Я',
            'а',
            'б',
            'в',
            'г',
            'д',
            'е',
            'ё',
            'ж',
            'з',
            'и',
            'й',
            'к',
            'л',
            'м',
            'н',
            'о',
            'п',
            'р',
            'с',
            'т',
            'у',
            'ф',
            'х',
            'ц',
            'ч',
            'ш',
            'щ',
            'ъ',
            'ы',
            'ь',
            'э',
            'ю',
            'я',
        );

        $lat = array(
            'A',
            'B',
            'V',
            'G',
            'D',
            'E',
            'E',
            'Gh',
            'Z',
            'I',
            'Y',
            'K',
            'L',
            'M',
            'N',
            'O',
            'P',
            'R',
            'S',
            'T',
            'U',
            'F',
            'H',
            'C',
            'Ch',
            'Sh',
            'Sch',
            'Y',
            'Y',
            'Y',
            'E',
            'Yu',
            'Ya',
            'a',
            'b',
            'v',
            'g',
            'd',
            'e',
            'e',
            'gh',
            'z',
            'i',
            'y',
            'k',
            'l',
            'm',
            'n',
            'o',
            'p',
            'r',
            's',
            't',
            'u',
            'f',
            'h',
            'c',
            'ch',
            'sh',
            'sch',
            'y',
            'y',
            'y',
            'e',
            'yu',
            'ya',
        );

        return str_replace($rus, $lat, $str);

    }

    public function curl(
        $action,
        $id = "",
        $limit = 100,
        $offset = 0,
        $order = "updated,desc",
        $created = null,
        $filter = ""
    ) {

        if (empty($id)) {

            $params = "$action?order=$order&limit={$limit}&offset={$offset}";

            if ($filter) {

                $params .= "&filter=".urlencode($filter);

            }

            if ($created) {

                $date = DateTime::createFromFormat("U", $created);

                $created = $date->format("Y-m-d H:i:s");

                $params .= "&filter=".urlencode("created>{$created}");

            }

            $service_url = API_LINK.$params;

        } else {

            $service_url = API_LINK."$action/$id";

        }

        $curl = curl_init($service_url);

        $headers = array(

            'Content-Type:application/json',

            'Authorization: Basic '.base64_encode(API_USER.":".API_PASS),

        );

        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,
            false); //IMP if the url has https and you don't want to verify source certificate


        $curl_response = curl_exec($curl);

        $response = json_decode($curl_response, true);

        curl_close($curl);

        return $response;

    }

    public function getTotal()
    {

        return $this->total;

    }

    private function multiCurl(
        $action,
        $limit = 100,
        $offset = 0,
        $order = "updated,desc",
        $created = null,
        $thrs = 5,
        $filter = ""
    ) {

        $mh = curl_multi_init();

        $conn = [];

        $result = array();

        $search = "";

        if ($filter) {

            $search .= "&filter=".urlencode($filter);

        }

        if ($created) {

            $date = DateTime::createFromFormat("U", $created);

            $created = $date->format("Y-m-d H:i:s");

            $search .= "&filter=".urlencode("created>{$created}");

        }

        for ($i = 0;$i < $thrs;$i++) {

            $loc_offset = $offset + $i * 100;

            $params = "$action?order=$order&limit={$limit}&offset={$loc_offset}{$search}";

            $service_url = API_LINK.$params;

            $conn[$i] = curl_init($service_url);

            $headers = array(

                'Content-Type:application/json',

                'Authorization: Basic '.base64_encode(API_USER.":".API_PASS),

            );

            curl_setopt($conn[$i], CURLOPT_HTTPHEADER, $headers);

            curl_setopt($conn[$i], CURLOPT_RETURNTRANSFER, 1); // возвращать результат


            curl_setopt($conn[$i], CURLOPT_FOLLOWLOCATION, 1); // если будет редирект - перейти по нему


            curl_setopt($conn[$i], CURLOPT_HEADER, 0); // не возвращать http-заголовок


            curl_setopt($conn[$i], CURLOPT_CONNECTTIMEOUT, 10); // таймаут соединения


            curl_setopt($conn[$i], CURLOPT_TIMEOUT, 10); // таймаут ожидания


            curl_setopt($conn[$i], CURLOPT_SSL_VERIFYPEER, false);

            curl_setopt($conn[$i], CURLOPT_SSL_VERIFYHOST, false);

            curl_multi_add_handle($mh, $conn[$i]);

        }

        do {

            $status = curl_multi_exec($mh, $active);

            $info = curl_multi_info_read($mh);

            if (false !== $info) {

                //var_dump($info);


            }

        } while ($status === CURLM_CALL_MULTI_PERFORM || $active);

        for ($i = 0;$i < $thrs;$i++) {

            $response = curl_multi_getcontent($conn[$i]);

            curl_multi_remove_handle($mh, $conn[$i]); // удаляем поток из мультикурла


            curl_close($conn[$i]); // закрываем отдельное соединение (поток)


            $response = json_decode($response, true);

            if ($response['rows']) {

                $result = self::arrayMerge($result, $response['rows']);

            }

        }

        return $result;

    }

    public function curlByLink($url)
    {

        if (stristr($url, "https") === false) {

            $url = API_LINK.$url;

        }

        $curl = curl_init($url);

        $headers = array(

            'Content-Type:application/json',

            'Authorization: Basic '.base64_encode(API_USER.":".API_PASS),

        );

        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,
            false); //IMP if the url has https and you don't want to verify source certificate


        $curl_response = curl_exec($curl);

        $response = json_decode($curl_response, true);

        curl_close($curl);

        return $response;

    }

    public function outerCUrl($url, $fields, $method = 'POST')
    {

        $curl = curl_init($url);

        $headers = array(

            'Content-Type:application/json',

            'Authorization: Basic '.base64_encode(API_USER.":".API_PASS),

        );

        $data_string = json_encode($fields);

        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,
            false); //IMP if the url has https and you don't want to verify source certificate


        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);

        curl_setopt($curl, CURLINFO_HEADER_OUT, true);

        curl_setopt($curl, CURLOPT_POST, true);

        curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

        $curl_response = curl_exec($curl);

        $response = json_decode($curl_response, true);

        curl_close($curl);

        return $response;

    }

    private function arrayMerge($array1, $array2)
    {
        $result = [];
        foreach ($array1 as $elem1) {
            $result[] = $elem1;
        }
        foreach ($array2 as $elem2) {
            $result[] = $elem2;
        }

        return $result;
    }

    public function getOrderById($id)
    {
        $order = self::curl(LINK_CUSTOMERORDER, $id);
        return $order;
    }

    public function getContactById($id)
    {
        $contact = self::curl(LINK_COUNTERPARTY, $id);
        return $contact;
    }

    public function updateContactById($id,$data)
    {
        $contact = self::curl(LINK_COUNTERPARTY, $id);
        return $contact;
    }

    public function test()
    {

        $order = self::curl(LINK_CUSTOMERORDER, "ebf45346-24a8-11e9-9107-504800099167");

        return $order;

    }

    private function phoneS($tel)
    {
        $tel = str_replace(array('(', ')', ' ', '-'), '', $tel);
        if ($tel['0'] == '8') {
            $telphon = substr($tel, 1);
        } elseif ($tel['0'] == '+' and $tel['1'] == 7) {
            $telphon = substr($tel, 2);
        } elseif ($tel['0'] == '7') {
            $telphon = substr($tel, 1);
        } else {
            $telphon = $tel;
        }

        return $telphon;
    }

    public function searchContact($data)
    {
        if (!empty($data['phone'])) {
            $phone    = $this->phoneS($data['phone']);
            $filter   = "filter=phone=~".$phone;
            $contacts = $this->curlByLink('entity/counterparty?'.$filter);
            $contact  = isset($contacts['rows'][0]) ? $contacts['rows'][0] : null;
            if ($contact) {
                return $contact;
            }
        }
        if (!empty($data['email'])) {
            $filter   = "filter=email=".$data['email'];
            $contacts = $this->curlByLink('entity/counterparty?'.$filter);
            $contact  = isset($contacts['rows'][0]) ? $contacts['rows'][0] : null;
            if ($contact) {
                return $contact;
            }
        }

        return null;
    }

    //Создаем контакт
    public function setContact($data)
    {
        $contact = array(
            "name"  => isset($data['name']) ? $data['name'] : 'Неизвестный контакт',
            "email" => isset($data['email']) ? $data['email'] : '',
            "phone" => isset($data['phone']) ? $data['phone'] : '',
        );
        if (!empty($data['fields'])) {
            $contact['attributes'] = $this->setValueContact($data['fields']);
        }
        $result = $this->outerCUrl('https://online.moysklad.ru/api/remap/1.1/entity/counterparty', $contact);

        return $result;
    }

    /**
     * Создаем сделку в Моем складе
     *
     * @param array $data
     * @param int $contact_id
     * @param int $manager
     *
     * @return  array
     */
    public function setLead($data, $contact_id, $manager)
    {
        $lead = array(
            'name'         => $this->generationLeadId(),
            'organization' => array(
                'meta' => array(
                    'href'      => 'https://online.moysklad.ru/api/remap/1.1/entity/organization/9a764991-7c62-11e4-90a2-8ecb00083e98',
                    'type'      => 'organization',
                    'mediaType' => 'application/json',
                ),
            ),
            //Контакт
            'agent'        => array(
                'meta' => array(
                    'href'      => 'https://online.moysklad.ru/api/remap/1.1/entity/counterparty/'.$contact_id,
                    'type'      => 'counterparty',
                    'mediaType' => 'application/json',
                ),
            ),
            //Ответственный менеджер
            'owner'        => array(
                'meta' => array(
                    'href'         => 'https://online.moysklad.ru/api/remap/1.1/entity/employee/'.$this->manager["{$manager}"],
                    'metadataHref' => 'https://online.moysklad.ru/api/remap/1.1/entity/employee/metadata',
                    'type'         => 'employee',
                    'mediaType'    => 'application/json',
                ),
            ),
            //Склад
            'state'        => array(
                'meta' => array(
                    'href'      => 'https://online.moysklad.ru/api/remap/1.1/entity/customerorder/metadata/states/90dac882-b3ed-11e3-b946-002590a28eca',
                    'type'      => 'state',
                    'mediaType' => 'application/json',
                ),
            ),
            'positions'    => array(
                array(
                    'quantity'   => 1,
                    'price'      => 0,
                    'discount'   => 0,
                    'vat'        => 0,
                    'assortment' => array(
                        'meta' => array(
                            'href'      => 'https://online.moysklad.ru/api/remap/1.1/entity/product/70b6c368-cb24-11e9-9ff4-34e800074488',
                            'type'      => 'product',
                            'mediaType' => 'application/json',
                        ),
                    ),
                    'reserve'    => 0,
                ),
            ),
        );

        if (!empty($data['fields'])) {
            $lead['attributes'] = $this->setValueLead($data['fields']);
        }
        if (!empty($data['text'])) {
            $lead['description'] = $data['text'];
        }
        $result = $this->outerCUrl('https://online.moysklad.ru/api/remap/1.1/entity/customerorder', $lead);

        return $result;
    }

    //Записываем дополнительные поля у контакта
    private function setValueContact($params)
    {
        $custum_fields = array();
        if (!empty($params)) {
            $fields = $this->getMetaClient();
            foreach ($fields as $field) {
                if (array_key_exists($field['name'], $params) !== false && !empty($params["{$field['name']}"])) {
                    $custum_fields[] = array(
                        'id'    => $field['id'],
                        'name'  => $field['name'],
                        'type'  => $field['type'],
                        'value' => $params["{$field['name']}"],
                    );
                }
            }
        }

        return $custum_fields;
    }

    //Записываем дополнительные поля у контакта
    private function setValueLead($params)
    {
        $custum_fields = array();
        if (!empty($params)) {
            $fields = $this->getMetaLead();
            foreach ($fields as $field) {
                if (array_key_exists($field['id'], $params) !== false && !empty($params["{$field['id']}"])) {
                    $custum_fields[] = array('id' => $field['id'], 'value' => $params["{$field['id']}"]);
                }
            }
        }

        return $custum_fields;
    }

    //Получаем список организаций
    public function getOrganization()
    {
        $organization = $this->curlByLink('https://online.moysklad.ru/api/remap/1.1/entity/organization');

        return $organization['rows'];
    }

    public function generationLeadId()
    {
        $path    = __DIR__.'/lead_id';
        $lead_to = file_get_contents($path);
        if ($lead_to === false) {
            $lead_to = 1000;
        }
        $lead_do = $lead_to + 1;
        file_put_contents($path, $lead_do);

        return 'ROI'.$lead_do;
    }

}


