<?php

require_once __DIR__ . "/Helper.php";

$helper = new Helper();

if (empty($_REQUEST['id'])) {
    die('Error');
};

$order = $helper->getOrderById($_REQUEST['id']);
$contactId = null;

$logData = array(
    'request' => $_REQUEST,
);

if (!empty($order['agent']['meta']['href'])) {
    $contactId = $helper->parse($order['agent']['meta']['href']);
    $logData['contactId'] = $contactId;
}
//
if ($contactId) {
    $contact = $helper->getContactById($contactId);
    $logData['contactPriceType'] = !empty($contact['priceType']) ? $contact['priceType'] : '';
}

$priceTypeId = 'd056a2c4-f8f2-11eb-0a80-06b7000ef661'; //Цена Настоящая

if (isset($contact) && (empty($contact['priceType']) || $contact['priceType'] === 'Цена продажи')) {
    $updateData = array(
        'priceType' => array(
            'meta' => array(
                'href' => "https://online.moysklad.ru/api/remap/1.2/context/companysettings/pricetype/{$priceTypeId}",
                'type' => 'pricetype',
                'mediaType' => 'application/json',
            )
        ),
    );

    $updateContact = $helper->outerCUrl("https://online.moysklad.ru/api/remap/1.2/entity/counterparty/{$contact['id']}", $updateData, 'PUT');

    $logData['updateContact'] = !empty($updateContact['id']) ? $updateContact['id'] : null;

}

logi($logData, 'Webhook', __DIR__ . '/log/hook.log');

function logi($val, $name, $fileName = null)
{
    $statusLog = 0;
    if ($statusLog > 0) {
        $file = $fileName != null ? $fileName : 'test.log';
        if (@file_exists($file)) {
            $size = @filesize($file);
            if ($size > 2500 * 1024) {
                @unlink($file);
            }
        }
        $data = date('Y-m-d H:i:s');
        $result = "\n[$name ($data)]\n" . print_r($val, true);
        file_put_contents($file, $result . "\n##########################################\n", FILE_APPEND);
    }
}
