<?php
$meta_title = 'Спасибо за заказ';
$meta_description = ''; // можно оставить пустым
$canonical = ''; // можно оставить пустым
$theme = 'light'; // dark или light

require_once 'parts/header.php';
?>

    <div class="welcome">
        <div class="container welcome__container">

            <header class="header">
                <nav class="header__nav nav">
                    <?php require 'parts/nav.php'; ?>
                    <div class="header__mob">
                        <a href="tel:+74994445402" class="header__mob-num">+7 (499) 444-54-02</a>
                        <div class="header__mob-time">с 10:00 до 20:00 <span>Работаем без выходных</span></div>
                        <div class="header__mob-call">
                            <a href="#popup-call" data-fancyform class="header__mob-btn btn">заказать звонок</a>
                        </div>
                    </div>
                </nav>
                <div class="header__bar">
                    <div class="header__main">
                        <div class="header__logo logo">
                            <a href="/" class="logo__link"></a>
                        </div>
                        <div class="header__time">
                            <span class="header__time-value">с 10:00 до 20:00</span>
                            <span class="header__time-label">Работаем без выходных</span>
                        </div>
                        <div class="header__phone">
                            <div class="header__phone-num">
                                <a href="tel:+74994445402" class="header__phone-link">+7 (499) 444-54-02</a>
                            </div>
                            <div class="header__phone-call">
                                <a href="#popup-call" data-fancyform class="header__phone-btn btn">заказать звонок</a>
                            </div>
                        </div>
                        <div class="header__toggle">
                            <button class="header__toggle-btn"></button>
                        </div>
                    </div>
                </div>
            </header>

            <div class="success-page">
                <div class="success-page__title">Благодарим за Заявку! <br>Ваша заявка принята и поставлена в обработку</div>
                <div class="success-page__product">
                    <div class="success-page__product-title">Попробуйте астраханскую рыбку из свежей партии</div>
                    <div class="success-page__product-list product-list">
                        <?php
                        $products = [
                            [
                                'name' => 'Осетр горячего копчения без кожи',
                                'weight' => 500,
                                'price' => 3500,
                                'old_price' => false,
                                'desc' => '',
                                'label' => '',
                                'img' => '/img/product/206x162/gk2.jpg',
                                'gallery' => [
                                    '/img/product/430x330/gk2.jpg',
                                ],
                            ],
                            [
                                'name' => 'Осетр горячего копчения нарезка',
                                'weight' => 300,
                                'price' => 2100,
                                'old_price' => false,
                                'desc' => '',
                                'label' => 'Хит продаж',
                                'img' => '/img/product/206x162/gnar.jpg',
                                'gallery' => [
                                    '/img/product/430x330/gnar.jpg',
                                ],
                            ],
                            [
                                'name' => 'Осетровый балык',
                                'weight' => 500,
                                'price' => 3250,
                                'old_price' => false,
                                'desc' => '',
                                'label' => '',
                                'img' => '/img/product/206x162/balyk3.jpg',
                                'gallery' => [
                                    '/img/product/430x330/balyk3.jpg',
                                ],
                            ],
                            [
                                'name' => 'Осетр холодного копчения',
                                'weight' => 500,
                                'price' => 3250,
                                'old_price' => false,
                                'desc' => '',
                                'label' => '',
                                'img' => '/img/product/206x162/hol.jpg',
                                'gallery' => [
                                    '/img/product/430x330/hol.jpg',
                                ],
                            ],
                        ];

                        foreach ($products as $product) {
                            require 'parts/product-item.php';
                        } ?>
                    </div>
                </div>
                <div class="success-page__back">
                    <button class="success-page__back-link" onclick="window.history.back()">Вернуться на главную</button>
                </div>
            </div>

        </div>
    </div>

<?php require_once 'parts/footer.php'; ?>