<?php
/**
 * Получение данных из JSON файда
 * @return array|mixed
 */
function getContactFormItemsFromJsonFile()
{ 
    if(is_file(__DIR__ . '/../wp-contact-forms.json')) {
        $json = json_decode(file_get_contents(__DIR__ . '/../wp-contact-forms.json'), 1);
        if($json) return $json; 
        return getFormsFromDb();
    }
    return [];
}

function getFormsFromDb()
{
    global $wpdb;
    $query = $wpdb->get_results("SELECT `ID`, `post_title`, `post_content` FROM `wp_posts` WHERE `post_type` = 'wpcf7_contact_form'");
    if(!$query) return null; 
    $items = [];
    foreach($query as $key => $item) {
        $email = null;
        $phone = null;
        $comment = null;
        $formData = explode('[submit "Submit"]', $item->post_content);

        if(!empty($formData[0])) { 
            if(preg_match('/\[email.? ([a-zA-Z_0-9-]+).*\]/', $formData[0], $data)) {
                $email = $data[1];
            }
            
            if(preg_match('/\[tel.? ([a-zA-Z_0-9-]+).*\]/', $formData[0], $data)) {
                $phone = $data[1];
            }

            if(preg_match_all('/\[\w+.?\s([a-zA-Z_0-9-]+).*\]/', $formData[0], $data)) {
                $cItems = array_map(function ($item) {
                    return "{{{$item}}}";
                }, $data[1]);
                $comment .= implode("\r\n", $cItems);
            }
        } 

        $items['items'][$item->ID] = [ 
            'name'     => 'your-name',
            'phone'    => $phone,
            'email'    => $email, 
            'comment'  => $comment, 
            'formname' => $item->post_title,
        ];
    }
    $items['is_db']  = 1;
    $items['fields'] = [
        'landingPage' => '{landingPage}',
        'source'      => '{source}',
        'utmCampaign' => '{utmCampaign}',
        'utmContent'  => '{utmContent}',
        'utmMedium'   => '{utmMedium}',
        'utmSource'   => '{utmSource}',
        'utmTerm'     => '{utmTerm}',
        'city'        => '{city}', 
    ];
    
    return $items;
}

/**
 * Сохранение данных в JSON файле
 * @param $data
 */
function saveContactFormItemsInJsonFile($data)
{ 
    file_put_contents(
        __DIR__ . '/../wp-contact-forms.json',
        json_encode($data)
    );

    $_SESSION['roistat']['success'] = "Настройки успешно сохранены";
}

/**
 * Нормализация данных из формы
 */
function roistatSaveWpContentData()
{
    $formData = $_POST['r-wp'];
    $formFields = $_POST['fields']; 
    $formList = [];
    $errors = null;
    if(is_array($formData) && !empty($formData)) {
        foreach ($formData as $key => $item) { 
            if(empty($item['id']) || (empty(trim($item['phone'])) && empty(trim($item['email']))))  {
                $_SESSION['roistat']['errors'][] = "В форме <b style='color:tomato'>{$key}</b> не заполнены обязательные поля id, (телефон или емайл)";
            } else {
                $id = $item['id'];
                unset($item['id']);
                $formList['items'][$id] = $item;
            }
        } 

        if(is_array($formFields) && !empty($formFields)) {
            foreach ($formFields['key'] as $key => $formField) {
                $formList['fields'][$formField] = $formFields['value'][$key];
            }
        }

        if(array_key_exists('title', $_POST)) {
            $formList['title'] = $_POST['title'];
        }
    }

    if(isset($_SESSION['roistat']['errors']) && count($_SESSION['roistat']['errors']) === count($formData)) {
        return null;
    }

    return saveContactFormItemsInJsonFile($formList);
}