<?php

/**
 * Получение данных из JSON файда
 * @return array|mixed
 */
function getWooCommerceItemsFromJsonFile()
{
    if(is_file(__DIR__ . '/../wp-woo-commerce.json')) {
        $json = file_get_contents(__DIR__ . '/../wp-woo-commerce.json');
        return json_decode($json, true);
    }
    return [];
}

/**
 * Сохранение данных в JSON файле
 * @param $data
 */
function saveWooCommerceItemsInJsonFile($data)
{
    if(isset($_SESSION['roistat'])) {
        unset($_SESSION['roistat']);
    }

    file_put_contents(
        __DIR__ . '/../wp-woo-commerce.json',
        json_encode($data)
    );
    $_SESSION['roistat']['success'] = "Настройки успешно сохранены";
}

function roistatSaveWooCommerceData()
{
    $formFields = $_POST['fields'];
    $formList = [];
    $errors = null;

    if(isset($_POST['woocommerce'])) {
        $formList = $_POST['woocommerce'];
    }

    if(is_array($formFields) && !empty($formFields)) {
        foreach ($formFields['key'] as $key => $formField) {
            $formList['fields'][$formField] = $formFields['value'][$key];
        }
    }
    return saveWooCommerceItemsInJsonFile($formList);
}

/**
 * @param $order_id
 */
function send_order_to_roistat($order_id) {
    if (mb_strlen($order_id) == 0 || ctype_space($order_id)) {
        return;
    }
    $roistatData = [];

    $order = wc_get_order($order_id);
    $addressList = [
        "Город: {$order->get_billing_city()}",
        "улица: {$order->get_billing_address_1()}",
        "дом: {$order->get_billing_address_2()}",
        "почтовый индекс: {$order->get_billing_postcode()}"
    ];

    $products = '';
    foreach ($order->get_items() as $item_id => $item) {
        $products .= "Название: {$item['name']}, кол-во: {$item['qty']}, цена: {$item['line_total']}\r\n";
    }

    $wooCommerceDataList = [
        'price'     => $order->get_total(),
        'shipping'  => $order->get_shipping_method(),
        'payment'   => $order->payment_method_title,
        'postcode' => $order->get_billing_postcode(),
        'address'  => implode(", ", $addressList),
        'products' => $products,
    ];

    $getFields = getWooCommerceItemsFromJsonFile();

    $comment = '';
    if(!empty($getFields)) {
        if(preg_match_all('|{{(.*)}}|Uis', $getFields['comment'], $result)) {
            $comment = $getFields['comment'];
            foreach ($result[1] as $key => $item) {
                if(array_key_exists($item, $wooCommerceDataList)) {
                    $comment = str_replace($result[0][$key], $wooCommerceDataList[$item], $comment);
                }
            }
        }

        if(!empty($getFields['fields'])) {
            $fieldsList = [];
            foreach ($getFields['fields'] as $key => $val) {
                if(preg_match_all('|{{(.*)}}|Uis', $val, $result)) {
                    if(array_key_exists($result[1][0], $wooCommerceDataList)){
                        $fieldsList[$key] = $wooCommerceDataList[$result[1][0]];
                    }
                }
                if($val == '{{formname}}') {
                    $fieldsList[$key] = !empty($formSettings['formname']) ? $formSettings['formname'] : 'Корзина';
                }
            }
            $roistatData['fields'] = $fieldsList + $getFields['fields'];
        }

    } else {
        $comment .= "Сумма заказа: {$wooCommerceDataList['price']}
            Доставка: {$wooCommerceDataList['shipping']}
            Способ оплаты: ${wooCommerceDataList['payment']}
            Адрес: {$wooCommerceDataList['address']}
            Товар:\r\n {$wooCommerceDataList['products']}";
    }

    $roistatData['fields']['price'] = $wooCommerceDataList['price'];
    $roistatData['title'] = !empty($getFields['title']) ? $getFields['title'] : 'Заявка с сайта {domain}';

    if (!empty($order->customer_message)) {
        $comment .= $order->customer_message;
    }

    $name = $order->billing_first_name;
    if(!empty($order->billing_last_name)) {
        $name .= " {$order->billing_last_name}";
    }

    $roistatData = array_merge($roistatData, [
        'name'    => "Клиент {$order->billing_phone}",
        'email'   => $order->billing_email,
        'phone'   => $order->billing_phone,
        'comment' => $comment,
    ]);

    return sendToRoistat($roistatData);
}

add_action('woocommerce_checkout_order_processed', 'send_order_to_roistat', 10, 1);

//TODO:: Сделать инетграцию с плагином formatter
//function formatter( $form_id )
//{
//    debug([
//        $form_id,
//        $_REQUEST
//    ]);
//}
//add_action('forminator_custom_form_submit_before_set_fields', 'formatter');