<?php
/**
 * Plugin Name:       Интеграция с Roistat
 * Plugin URI:        https://roistat.com/
 * Description:
 * Version:           1.0
 * Requires at least: 5.2
 * Requires PHP:      5.6
 * Author:            Borzz
 * Author URI:        https://roistat.com/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       roistat-integration
 * Domain Path:       /lang
*/

function debug($str)
{
    echo "<pre>";
    print_r($str);
    echo "</pre>";
}

/**
 * Регистрация меню
 */
function wpdocs_register_my_custom_menu_page() {
    add_menu_page(
        esc_html__( 'Интеграция с Roistat', 'roistat-integration' ),
        'Интеграция с Roistat',
        'manage_options', 
        'roistat-integration',
        'roistatWpShowContent',
        'dashicons-update-alt',
        6
    );
}
add_action( 'admin_menu', 'wpdocs_register_my_custom_menu_page' );

/**
 * Отображение шаблона
 */
function roistatWpShowContent()
{
    $baseUrl = admin_url( 'admin.php?page=roistat-integration' );
    $getTab = !empty($_GET['tab']) ? $_GET['tab'] : 'wp7';

    if(isset($_POST['roistat-wp7-contact-message']))
    {
        roistatSaveWpContentData();
    }

    if(isset($_POST['roistat-genera-message'])) {
        roistatSaveGeneralData();
    }

    if(isset($_POST['roistat-woocommerce-message'])) {
        roistatSaveWooCommerceData();
    }

    include_once __DIR__ . '/views/index.php';
}

/**
 * регистрация скриптов
 */
function roistatWp_register_assets()
{
    wp_register_style(
        'roistat_wp_style',
        plugins_url('assets/css/admin.css', __FILE__)
    );

    wp_register_script(
        'roistat_wp_scripts',
        plugins_url('assets/js/admin.js', __FILE__)
    );
}
add_action('admin_enqueue_scripts', 'roistatWp_register_assets');

/**
 * Отображение скриптов
 * @param $hook
 */
function roistatWp_load($hook)
{
    if($hook != 'toplevel_page_roistat-integration' && $hook != 'roistat-integration/index.php') {
        return;
    }
    wp_enqueue_script('roistat_wp_scripts');
    wp_enqueue_style('roistat_wp_style');
}
add_action('admin_enqueue_scripts', 'roistatWp_load');


/**
 * Для работы с JSON файлом
 */
require_once __DIR__ . '/functions/r-json.php';

/**
 * Файл для отправки проксилида
 */
require_once __DIR__ . '/functions/r-roistat-sender.php';

/**
 * Файл события Wp Contact 7
 */
require_once __DIR__ . '/functions/r-wp-contact-7.php';

/**
 * Файл для сохранения обших настроек
 */
require_once __DIR__ . '/functions/r-general.php';

/**
 * Файл для сохранения обших настроек
 */
require_once __DIR__ . '/functions/r-woo-commerce.php';