<?php
$formItems = getContactFormItemsFromJsonFile();
?>

<div class="r-row">
    <div class="col-md-8">
        <form action="" method="post" class="r-wp-form">

            <div class="r-form" style="margin-bottom: 20px">
                <div class="r-field-title">
                    <label for="title">Название заявки</label>
                </div>
                <div class="r-inp">
                    <?php
                        $value = !empty($formItems['title']) ? $formItems['title'] : 'Заявка с формы: {{formname}}';
                    ?>
                    <input name="title" type="text" id="title" value="<?= $value ?>" class="regular-text">
                </div>
            </div>

            <?php if(isset($formItems['is_db'])) : ?>
                <p style="color: tomato; font-size: 18px; text-align: center">
                    Не забудьте сохранить настройки!!!
                </p>
            <?php endif ?>

            <?php if(!empty($formItems)) : ?>
                <?php include __DIR__ . "/_data-form.php";?>
            <?php else: ?>
                <?php include __DIR__ . "/_empty-form.php";?>
            <?php endif; ?>

            <div class="r-add-fields">
                <button type="button" class="hide-if-no-js r-btn-add-fields" data-number="0">
                    <i class="dashicons-before dashicons-plus"></i> Добавить доп.поле
                </button>
            </div>

            <?php
                wp_nonce_field( 'roistat-wp7-contact-save', 'roistat-wp7-contact-message' );
                submit_button();
            ?>
        </form>
    </div>
    <div class="col-md-4">
        <?php include __DIR__ . '/_contact-inst.php' ?>
    </div>
</div>


