<?php
/**
 * Шаблон шапки (header.php)
 */
?>

<?php
$critical = file_get_contents(get_template_directory_uri() . "/css/critical.css");

function compress($buffer) {
    // удалить комментарии
    $buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
    // удалить табуляции, пробелы, символы новой строки и т.д.
    $buffer = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $buffer);
    return $buffer;
}

function get_future_date($day) {
    $date = date("d ", strtotime($day));
    $arr = ['января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря'];
    $month = date('n') - 1;
    // если следующий день попадает в следующем месяце
    if (date('d') > date("d", strtotime($day))) {
        $month = (int) date('n');
        if ($month === 12) {
            $month = 0;
        }
    }
    $result = $date. ' ' .$arr[$month];
    return $result;
}

function get_banks_left() {
    $current_day = date('N');
    $banks = 18 - $current_day;
    return $banks;
}
?>
<!doctype html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="format-detection" content="telephone=no">
	<meta name="robots" content="noindex, nofollow" />
	<title><?php wp_title(''); ?></title>
    <style><?= compress($critical) ?></style>
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/style.css?v=1.3">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/jquery.fancybox.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/slick.css">
    <?php if (is_product() || (is_cart() && (strpos($_SERVER['REQUEST_URI'], 'order-received') == false))): ?>
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/product.css">
    <?php endif; ?>
    <?php if (is_cart() && (strpos($_SERVER['REQUEST_URI'], 'order-received') == false)): ?>
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/cart.css">
    <?php endif; ?>
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style.css">
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <?php if ($canonical): ?>
        <link rel="canonical" href="<?= $canonical ?>">
    <?php endif; ?>
	<?php wp_head(); // необходимо для работы плагинов и функционала ?>
</head>
<body <?php body_class(); ?>>


<div class="wrapper">