<?php
$filter = true;
?>

<?php
/**
 * Template Name: Главная страница
 * Шаблон обычной страницы (page.php)
 */
get_header(); // подключаем header.php ?>
<?php if ( have_posts() ) while ( have_posts() ) : the_post(); // старт цикла ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>> <?php // контэйнер с классами и id ?>

    <div class="welcome">
        <div class="container welcome__container">

            <?php require get_template_directory() . '/parts/header-inner.php'; ?>

            <?php
                $welcome_product = [
                    'name' => 'Икра черная "Премиум"',
                    'weight' => 250,
                    'price' => 11990,
                    'old_price' => 13990,
                    'desc' => '<b>Состав:</b> икра осетра, соль.',
                    'label' => '',
                    'img' => '',
                    'gallery' => [
                        '/img/product/430x330/prem250.jpg',
                        '/img/product/430x330/prem1.jpg',
                        '/img/product/430x330/prem2.jpg',
                        '/img/product/430x330/prem3.jpg',
                        '/img/product/430x330/prem4.jpg',
                        '/img/product/430x330/sert1.jpg',
                        '/img/product/430x330/sert2.jpg',
                    ],
                    'review' => [
                        '/img/reviews/premium1.jpg',
                        '/img/reviews/premium2.jpg',
                        '/img/reviews/premium3.jpg',
                        '/img/reviews/premium4.jpg',
                        '/img/reviews/premium5.jpg',
                    ],
                ];
            ?>

            <div class="dark-welcome dark-welcome_home" data-base='<?= json_encode($welcome_product) ?>'>
                <h1 class="dark-welcome__title">Астраханская фермерская черная икра</h1>

		<?php
		
		$args_kat = array(
			'post_type' => 'product',
			'post_status' => 'publish',
			'tax_query' => array(
					array(
					 'taxonomy' => 'product_cat',
					 'field'    => 'slug',
					 'terms'     => 'banner-glavnaya',
					 'operator'  => 'IN'
					)
				 )
		);
		$thequery_kat = new WP_Query($args_kat);
		
		if ( $thequery_kat->have_posts() ) {
			while ( $thequery_kat->have_posts() ) {
				$thequery_kat->the_post();
				global $product;

		?>

                <div class="dark-welcome__row">
                    <div class="dark-welcome__img">
                        <div class="dark-welcome__img-inner">
                            <img src="<?php echo get_template_directory_uri(); ?>/img/welcome/img-welcome-premium250.png" width="782" height="547" alt="">
                        </div>
                    </div>
                    <div class="dark-welcome__about">
                        <div class="dark-welcome__name"><?php echo get_the_title(); ?></div>
                        <div class="dark-welcome__desc">По специальной цене</div>
                        <div class="dark-welcome__price">
                            <div class="dark-welcome__price-current"><?php echo number_format($product->get_sale_price(), 0, '', ' '); ?> ₽</div>
                            <div class="dark-welcome__price-old"><?php echo number_format($product->get_regular_price(), 0, '', ' '); ?> ₽</div>
                        </div>
                        <div class="dark-welcome__action">
                            <a href="?add-to-cart=<?php echo $product->get_id(); ?>" class="dark-welcome__btn btn button product_type_simple add_to_cart_button ajax_add_to_cart" data-quantity="1" data-product_id="<?php echo $product->get_id(); ?>" onclick="yaCounter64691695.reachGoal ('zakaz-na-glav'); return true;">Заказать со скидкой</a>
                            <div class="dark-welcome__date">Только до <?= get_future_date('next sunday') ?></div>
                        </div>
                    </div>
                </div>
		<?php
			}
		}

		wp_reset_postdata();
				
		?>
                <div class="dark-welcome__advant">
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-map"/></svg>
                        <div class="dark-welcome__advant-title">Прямые поставки <br>из Астрахани</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-delivery"/></svg>
                        <div class="dark-welcome__advant-title">Бесплатная <br>доставка от 3 часов</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-menu-01"/></svg>
                        <div class="dark-welcome__advant-title">Без <br>консервантов</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-caviar"/></svg>
                        <div class="dark-welcome__advant-title">Настоящий <br>малосол</div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="product-wrap">
        <div class="container">

            <div class="product-head" id="catalog">
                <div class="product-head__label">Широкий ассортимент</div>
                <div class="product-head__title">Фермерская икра</div>
            </div>
			
			<?php
				$osetg = "osetrovaya-ikra";
				$belg = "beluzhya-ikra";
				$pausg = "pausnaya-ikra";
			    $pdsg = "50g";
				$stog = "100g";
				$sdg = "125g";
				$dpg = "250g";
				$psg = "500g";
				$okg = "1kg";
				$akcii = "akcii";	
			?>

            <?php if (isset($filter) && $filter) { require get_template_directory() . '/parts/filter.php'; } ?>

            <div id="products">
			
				<section class="product-block product-block_open product-block_style-1 filtr_main">
				<div class="container">
					<div class="product-block__body product-list">

				<?php
					$args = array(
						'tax_query' => array(
						'relation' => 'OR', // товары принадлежащие любому из указанных терминов таксономии
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $osetg
						),
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $belg
						),
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $pausg
						),
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $pdsg
						),
						
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $stog
						),
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $sdg
						),
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $dpg
						),
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $psg
						),
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $okg
						),
						array(
						 'taxonomy' => 'product_cat',
						 'field' => 'slug',
						 'terms' => $akcii
						)
					),
					// Параметры отображения выведенных товаров
					'posts_per_page' => -1, // количество выводимых товаров
					'post_type' => 'product', // тип товара
					'orderby' => 'title', // сортировка
				);

				$loop = new WP_Query( $args );
				while ( $loop->have_posts() ) : $loop->the_post();
				global $product;
				?>
					<!-- Цикл для вывода выбранных товаров -->
					
						<?php require get_template_directory() . '/parts/product-item.php'; ?>

					<?php endwhile; ?>
					<!-- Сброс данных запроса -->
					<?php wp_reset_query(); ?>

					</div>
				</div>
				</section>
			
				<?php 
					$terms_id = array(30, 28, 17, 18, 21, 19, 24, 20, 25);
					
					foreach ($terms_id as $term_id) {
						
						require get_template_directory() . '/parts/product-template.php';
						
					}
				 ?>


				
				<?php 
					$term_id = 27;
					
					require get_template_directory() . '/parts/product-template.php';
						
				 ?>

            </div>

        </div>
    </div>

<?php require get_template_directory() . '/parts/about.php'; ?>
<?php require get_template_directory() . '/parts/why.php'; ?>

<div class="bg-wrap">
    <div class="container">
        <?php require get_template_directory() . '/parts/review.php'; ?>
        <?php require get_template_directory() . '/parts/video.php'; ?>
    </div>
</div>

<?php require get_template_directory() . '/parts/certificate.php'; ?>
<?php require get_template_directory() . '/parts/delivery.php'; ?>

<div class="page-text">
    <div class="container">
        <div class="page-text__desc">
            <h2>Полезная черная икра - залог здоровья вашей семьи!</h2>
            <p>В нашем интернет-магазине вы можете купить черную икру без консервантов и с гарантией качества. Почему мы так в этом уверены? Наша продукция:</p>
            <ul>
                <li>Без искусственных консервантов. Только польза и чистый вкус без посторонних примесей.</li>
                <li>Приготовлена по ГОСТ! Гарантия качества государственного стандарта. Тот самый ГОСТ и тот самый вкус.</li>
                <li>Получена от крупнейшего Астраханского фермерского хозяйства - РК Акватрейд. Польза астраханских осетровых в каждой банке.</li>
                <li>Продается от производителя. Мы сами посолили всю продукцию и доставили ее вам, нет дополнительных посредников и наценок. Именно поэтому у нас такие низкие цены.</li>
                <li>Контролируется лично Егором Осетровым. Это реальный, радеющий за свое дело человек, который пробует каждую партию лично.</li>
                <li>Изготовлена командой мастеров своего дела. Вся команда технологов - люди с большим опытом. Нам можно доверять.</li>
            </ul>
            <p>Если вы хотите побаловать себя настоящей, фермерской черной икрой астраханских осетров - звоните или оставляйте заказ на сайте, доставка по Москве бесплатная!</p>

        </div>
    </div>
</div>

	</article>
<?php endwhile; // конец цикла ?>

<?php get_footer(); // подключаем footer.php ?>