<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

?>

<?php
$filter = true;
?>


    <div class="welcome">
        <div class="container welcome__container">

            <?php require get_template_directory() . '/parts/header-inner.php'; ?>

        </div>
    </div>

    <div class="product-wrap">
        <div class="container">

            <div class="product-head" id="catalog">
			<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
                <div class="product-head__label kroshki"><a href="/">Черная икра</a> - <?php woocommerce_page_title(); ?></div>
                <h1 class="product-head__title"><?php woocommerce_page_title(); ?></h1>
			<?php endif; ?>
            </div>
			
			<?php
				$osetg = "osetrovaya-ikra";
				$belg = "beluzhya-ikra";
				$pausg = "pausnaya-ikra";
			    $pdsg = "50g";
				$stog = "100g";
				$sdg = "125g";
				$dpg = "250g";
				$psg = "500g";
				$okg = "1kg";
				$akcii = "akcii";	
			?>

            <?php if (isset($filter) && $filter) { require get_template_directory() . '/parts/filter.php'; } ?>

            <div id="products">
			
				<section class="product-block product-block_open product-block_style-1 filtr_main">
				<div class="container">
					<div class="product-block__body product-list">

				<?php
				
				$cate = get_queried_object();
				$cateID = $cate->term_id;
				
					$args = array(
						'tax_query' => array(
							array(
								'taxonomy' => 'product_cat',
								'field'    => 'id',
								'terms'    => $cateID
							)
					),
					// Параметры отображения выведенных товаров
					'posts_per_page' => -1, // количество выводимых товаров
					'post_type' => 'product', // тип товара
					'orderby' => 'title', // сортировка
				);

				$loop = new WP_Query( $args );
				while ( $loop->have_posts() ) : $loop->the_post();
				global $product;
				?>
					<!-- Цикл для вывода выбранных товаров -->
					
						<?php require get_template_directory() . '/parts/product-item.php'; ?>

					<?php endwhile; ?>
					<!-- Сброс данных запроса -->
					<?php wp_reset_query(); ?>

					</div>
				</div>
				</section>
			
			<?php 
			
				if ($cateID == '16') {
					
					// Осетровая икра
					
					$terms_id = array(17, 18, 19, 20, 21);
					
					foreach ($terms_id as $term_id) {
						
						require get_template_directory() . '/parts/product-template.php';
						
					}
					
				}
				else if ($cateID == '22') {
					
					// Белужья икра
					
					$terms_id = array(24, 25);
					
					foreach ($terms_id as $term_id) {
						
						require get_template_directory() . '/parts/product-template.php';
						
					}
					
				}
				else if ($cateID == '23') {
					
					// Паюсная икра
					
					$terms_id = array(20, 25);
					
					foreach ($terms_id as $term_id) {
						
						require get_template_directory() . '/parts/product-template.php';
						
					}
					
				} else {
					
					$term_id = $cateID;
				
					require get_template_directory() . '/parts/product-template.php';
				
				}
			
			?>
				
            </div>

        </div>
    </div>
	
<div class="page-text katalog-text">
    <div class="container">
        <div class="page-text__desc">
			<?php if(get_field('текст_внизу', 'term_' . $cateID)) { echo get_field('текст_внизу', 'term_' . $cateID); } ?>
        </div>
    </div>
</div>


<?php

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
//do_action( 'woocommerce_sidebar' );

get_footer( 'shop' );
