<?php
$meta_title = 'Черная икра от Егора Осетрова';
$meta_description = ''; // можно оставить пустым
$canonical = ''; // можно оставить пустым
$theme = 'dark'; // dark или light
$filter = true;

require_once 'parts/header.php';
?>

    <div class="welcome">
        <div class="container welcome__container">

            <?php require 'parts/header-inner.php'; ?>

            <?php
            $welcome_product = [
                'name' => 'ЗАБОЙНАЯ ИКРА ОСЕТРА "ЦАРСКАЯ"',
                'weight' => 250,
                'price' => 20990,
                'old_price' => 23990,
                'desc' => '<b>Состав:</b> икра осетра, соль.',
                'label' => '',
                'img' => '',
                'gallery' => [
                    '/img/product/430x330/carskaya250.jpg',
                    '/img/product/430x330/carskaya1.jpg',
                    '/img/product/430x330/carskaya2.jpg',
                    '/img/product/430x330/carskaya3.jpg',
                    '/img/product/430x330/carskaya4.jpg',
                    '/img/product/430x330/carskaya5.jpg',
                    '/img/product/430x330/carskaya6.jpg',
                ],
                'review' => [
                    '/img/reviews/carskaya1.jpg',
                    '/img/reviews/carskaya2.jpg',
                    '/img/reviews/carskaya3.jpg',
                    '/img/reviews/carskaya4.jpg',
                    '/img/reviews/carskaya5.jpg',
                ],
            ];
            ?>
            <div class="dark-welcome dark-welcome_home" data-base='<?= json_encode($welcome_product) ?>'>
                <h1 class="dark-welcome__title">Астраханская фермерская черная икра</h1>
                <div class="dark-welcome__row">
                    <div class="dark-welcome__img">
                        <div class="dark-welcome__img-inner">
                            <img src="/img/welcome/img-welcome-carskaya125.png" width="627" height="439" alt="">
                        </div>
                    </div>
                    <div class="dark-welcome__about">
                        <div class="dark-welcome__name">ЗАБОЙНАЯ ИКРА ОСЕТРА "ЦАРСКАЯ" 250г</div>
                        <div class="dark-welcome__desc">По специальной цене</div>
                        <div class="dark-welcome__price">
                            <div class="dark-welcome__price-current">20 990 ₽</div>
                            <div class="dark-welcome__price-old">23 990 ₽</div>
                        </div>
                        <div class="dark-welcome__action">
                            <div class="dark-welcome__btn btn js-buy">Заказать со скидкой</div>
                            <div class="dark-welcome__date">Только до <?= get_future_date('next sunday') ?></div>
                        </div>
                    </div>
                </div>
                <div class="dark-welcome__advant">
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico">
                            <use xlink:href="#ico-advant-map"/>
                        </svg>
                        <div class="dark-welcome__advant-title">Астраханская <br>фермерская икра</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico">
                            <use xlink:href="#ico-advant-delivery"/>
                        </svg>
                        <div class="dark-welcome__advant-title">Бесплатная <br>доставка от 3 часов</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico">
                            <use xlink:href="#ico-menu-01"/>
                        </svg>
                        <div class="dark-welcome__advant-title">Приготовлена по <br>ГОСТ</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico">
                            <use xlink:href="#ico-advant-caviar"/>
                        </svg>
                        <div class="dark-welcome__advant-title">Вкус <br>из детства</div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="product-wrap">
        <div class="container">

            <div class="product-head" id="catalog">
                <div class="product-head__label">Широкий ассортимент</div>
                <div class="product-head__title">Фермерская икра</div>
            </div>

            <?php if (isset($filter) && $filter) { require 'parts/filter.php'; } ?>

            <div id="products">
                <?php require 'parts/product-popular.php'; ?>
                <?php require 'parts/product-set.php'; ?>
                <?php require 'parts/product-carskaya.php'; ?>
				<?php require 'parts/product-classic.php'; ?>
                <?php require 'parts/product-premium.php'; ?>
				<?php require 'parts/product-paus.php'; ?>
                <?php require 'parts/product-royalpaus.php'; ?>
                <?php require 'parts/product-otbor.php'; ?>
                <?php require 'parts/product-royal.php'; ?>
                
                
                <div class="product-head">
                    <div class="product-head__title">Икра мировых брендов</div>
                </div>
                <?php require 'parts/product-beluga.php'; ?>
                <?php require 'parts/product-delicacy.php'; ?>
            </div>

        </div>
    </div>

<?php require 'parts/about.php'; ?>
<?php require 'parts/why.php'; ?>

    <div class="bg-wrap">
        <div class="container">
            <?php require 'parts/review.php'; ?>
            <?php require 'parts/video.php'; ?>
        </div>
    </div>

<?php require 'parts/certificate.php'; ?>
<?php require 'parts/delivery.php'; ?>

<?php require_once 'parts/footer.php'; ?>