$(document).ready(function() {

    /**
     * Попап для заказа товара
     */

    $('body').on('click', '.js-buy', function () {

        let parent = $(this).parents('[data-base]');
        let data = parent.data('base');

        if (data.gallery.length > 1) {
            let galleryMain = '';
            let galleryNav = '';
            data.gallery.forEach(function(item, i) {
                galleryMain += '<div class="popup-cart__gallery-item"><img src="'+item+'" width="430" height="330" alt=""></div>';
                galleryNav += '<div class="popup-cart__gallery-thumb"><img src="'+item+'" width="86" height="66" alt=""></div>';
            });
            let gallery = '<div class="popup-cart__gallery-main">'+galleryMain+'</div><div class="popup-cart__gallery-nav">'+galleryNav+'</div>';
            $('.popup-cart__img').html(gallery);

            $('.popup-cart__gallery-main').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: false,
                fade: true,
                asNavFor: '.popup-cart__gallery-nav',
                draggable: false,
            });
            $('.popup-cart__gallery-nav').slick({
                slidesToShow: 4,
                slidesToScroll: 1,
                asNavFor: '.popup-cart__gallery-main',
                dots: false,
                focusOnSelect: true,
                variableWidth: true,
                prevArrow: '<button class="popup-cart__gallery-arrow slick-prev"><svg><use xlink:href="#ico-arrow"/></svg></button>',
                nextArrow: '<button class="popup-cart__gallery-arrow slick-next"><svg><use xlink:href="#ico-arrow"/></svg></button>',
            });
        } else {
            $('.popup-cart__img').html('<img src="'+data.gallery[0]+'" width="430" height="330" alt="">');
        }

        if (data.weight) {
            $('.popup-cart__title').html(data.name+' <span>'+data.weight+'г</span>');
            $('.popup-cart [name="name"]').val(data.name+' '+data.weight+'г');
        } else {
            $('.popup-cart__title').html(data.name);
            $('.popup-cart [name="name"]').val(data.name);
        }

        $('.popup-cart__price-new').text(data.price.toLocaleString('ru')+'₽');

        if (data.old_price) {
            $('.popup-cart__price-old').text(data.old_price.toLocaleString('ru')+'₽').show();
        } else {
            $('.popup-cart__price-old').text('').hide();
        }

        if (data.desc) {
            $('.popup-cart__desc').html(data.desc).show();
        } else {
            $('.popup-cart__desc').html('').hide();
        }

        if (data.label) {
            $('.popup-cart__label').text(data.label).show();
        } else {
            $('.popup-cart__label').text('').hide();
        }

        if (data.review) {
            let review = '';
            data.review.forEach(function(item, i) {
                review += '<div class="carousel__item"><a class="carousel__link" href="'+item+'" data-fancybox="review"><img src="'+item+'"></a></div>';
            });
            $('.popup-cart__review-main').html('<div class="carousel">'+review+'</div>');
            let popupReview = $(".popup-cart__review .carousel");
            popupReview.slick({
                dots: false,
                infinite: true,
                arrows:true,
                slidesToShow: 4,
                slidesToScroll: 1,
                prevArrow: '<button class="carousel__arrow carousel__arrow_prev"><svg><use xlink:href="#ico-arrow"/></svg></button>',
                nextArrow: '<button class="carousel__arrow carousel__arrow_next"><svg><use xlink:href="#ico-arrow"/></svg></button>',
                responsive: [
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            variableWidth: true,
                            centerMode: true,
                            centerPadding: false,
                            arrows: false,
                            dots: true,
                            dotsClass: 'carousel__dots',
                        }
                    }
                ]
            });

            let total = popupReview.slick("getSlick").slideCount;
            let currentSlide = popupReview.slick('slickCurrentSlide');
            let slide = currentSlide + 1;

            popupReview.after('<div class="carousel-count"><span class="carousel-count__current">'+slide+'</span> / '+ total +'</div>');

            popupReview.on('afterChange', function(event, slick, currentSlide, nextSlide){
                let currentChange = currentSlide + 1;
                popupReview.next('.carousel-count').find('.carousel-count__current').text(currentChange);
            });

            $('.popup-cart__review').show();
        } else {
            $('.popup-cart__review').hide();
        }

        $.fancybox.open({
            src  : '#popup-buy',
            type : 'inline',
            opts : {
                touch: false,
                autoFocus: false,
                buttons: [
                    'close',
                ],
                afterClose: function () {
                    $('.popup-cart__review-toggle').removeClass('popup-cart__review-toggle_active').siblings('.popup-cart__review-main').slideUp('fast');
                }
            }
        });

    });

    /**
     * FancyBox 3
     */

    $("[data-fancyform]").fancybox({
        buttons: [
            'close',
        ],
        touch: false,
        autoFocus: false,
    });

    $("[data-fancybox]").fancybox({
        buttons: [
            'close',
        ],
    });

    /**
     * Выбор количества товара
     */

    $('.popup-cart__amount-btn_minus').click(function () {
        var $input = $(this).parent().find('input');
        var count = parseInt($input.val()) - 1;
        count = count < 1 ? 1 : count;
        $input.val(count);
        $input.change();
        return false;
    });
    $('.popup-cart__amount-btn_plus').click(function () {
        var $input = $(this).parent().find('input');
        $input.val(parseInt($input.val()) + 1);
        $input.change();
        return false;
    });
    $('.popup-cart__amount-control').change(function () {
        let val = Number($(this).val());
        console.log(val)
        if (!val) {
            $(this).val(1);
        }
    });
    // фильтрация полей на ввод только цифр
    $('body').on('keypress', '[data-only="number"]', function(e) {
        var ASCIICode = (e.which) ? e.which : e.keyCode
        if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
            return false;
        return true;
    });


    /**
     * Отзывы
     */

    $('.popup-cart__review-toggle').click(function () {
        $(this).toggleClass('popup-cart__review-toggle_active').siblings('.popup-cart__review-main').slideToggle('fast', function () {
            $('.popup-cart__review-main .carousel').slick('refresh');
        });
    });

    $(".carousel").each(function (i,el) {
        $(el).slick({
            dots: false,
            infinite: true,
            arrows:true,
            slidesToShow: 4,
            slidesToScroll: 1,
            prevArrow: '<button class="carousel__arrow carousel__arrow_prev"><svg><use xlink:href="#ico-arrow"/></svg></button>',
            nextArrow: '<button class="carousel__arrow carousel__arrow_next"><svg><use xlink:href="#ico-arrow"/></svg></button>',
            responsive: [
                {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                        variableWidth: true,
                        centerMode: true,
                        centerPadding: false,
                        arrows: false,
                        dots: true,
                        dotsClass: 'carousel__dots',
                    }
                }
            ]
        });

        let total = $(el).slick("getSlick").slideCount;
        let currentSlide = $(el).slick('slickCurrentSlide');
        let slide = currentSlide + 1;

        $(el).after('<div class="carousel-count"><span class="carousel-count__current">'+slide+'</span> / '+ total +'</div>');

        $(el).on('afterChange', function(event, slick, currentSlide, nextSlide){
            let currentChange = currentSlide + 1;
            $(el).next('.carousel-count').find('.carousel-count__current').text(currentChange);
        });
    });



    /**
     * Плавная прокрутка по якорю
     */

    $('.scroll-link').on('click', function (event) {
        event.preventDefault();
        let target = $(this);
        let url = target.attr('href');
        $('html, body').animate({
            scrollTop: $(url).offset().top - 48,
        }, 750);
    });

    $('.nav__link.scroll-link').click(function () {
        $('body').removeClass('menu-opened');
    });


    /**
     * Стрелка наверх
     */

    $(window).scroll(function () {
        if ($(this).scrollTop() > 200) {
            $('#back-top').fadeIn();
        } else {
            $('#back-top').fadeOut();
        }
    });

    $('#back-top a').click(function () {
        $('body,html').animate({
            scrollTop: 0
        }, 800);
        return false;
    });


    /**
     * Адаптив
     */

    onLoadPage();

    function onLoadPage(e){
        onResizePage();
        window.addEventListener("resize", onResizePage);
    }

    function onResizePage (e){

        let mq_max_991 = window.matchMedia("screen and (max-width: 991px)");
        let mq_max_500 = window.matchMedia("screen and (max-width: 500px)");
        let viewProduct = 4;

        if (mq_max_500.matches) {
            viewProduct = 3;
        }

        if (mq_max_991.matches) {

            $('.product-block').each(function (i, el) {
                let products = $(this).find('.product');
                if (products.length > viewProduct) {
                    $(this).find('.product-block__foot').show();
                }
            });

        } else {

            $('.product-block__foot').removeAttr('style');

        }

    }

    $('.product-block__toggle').click(function () {
        $(this).parents('.product-block').toggleClass('product-block_open');
    });


    /**
     * Плавающая шапка на десктопе
     */

    $(window).scroll(function() {
        let height = $(window).scrollTop();
        if(height > 900){
            $('.header').addClass('header_fixed');
        } else{
            $('.header').removeClass('header_fixed');
        }
    });


    /**
     * Мобильное меню
     */

    $('.header__toggle-btn').click(function () {
        $('body').toggleClass('menu-opened');
    });

});