<?php

$products = [
       [
          'name' => 'Набор “Августовский”',
        'weight' => 800,
        'price' => 14790,
        'old_price' => 17080,
        'desc' => '<b>В составе:</b> <br>250г Икра черная “Классик”, 250г красная икра, 300г осетр горячего копчения',
        'label' => '',
        'img' => '/img/product/340x250/nabor1.jpg',
        'gallery' => [
            '/img/product/430x330/nabor1.jpg',
        ],
    ],
	[
        'name' => 'Набор “Семейный”',
        'weight' => 1450,
        'price' => 9490,
        'old_price' => false,
        'desc' => '<b>В составе:</b> <br>500г красная икра, 200г паштет из осетра с овощами, 500г осетр горячего копчения, 250г колбаса из осетра',
        'label' => '',
        'img' => '/img/product/340x250/nabor-sem.jpg',
        'gallery' => [
            '/img/product/430x330/nabor-sem.jpg',
        ],
    ],
  [
       'name' => 'Набор “Астраханский”',
        'weight' => 1250,
        'price' => 14490,
        'old_price' => 16670,
        'desc' => '<b>В составе:</b> <br>250г икра черная "Классик", 210г хе из осетра, 210г осетр в масле, 300г осетр горячего копчения',
        'label' => '',
        'img' => '/img/product/340x250/nabor-ast2.jpg',
        'gallery' => [
            '/img/product/430x330/nabor-ast2.jpg',
        ],
    ],
    [
        'name' => 'Набор “Вкус из детства”',
        'weight' => 450,
        'price' => 35490,
        'old_price' => 38980,
        'desc' => '<b>В составе:</b> <br>250г икра Русского осетра ЗАБОЙНАЯ “Царская”, 200г икра паюсная.',
        'label' => '',
        'img' => '/img/product/340x250/nabor4.jpg',
        'gallery' => [
            '/img/product/430x330/nabor4.jpg',
        ],
    ],
];
?>

<section class="product-block product-block_open product-block_set product-block_style-4">
    <div class="product-block__head">
        <div class="product-block__title">
            <div class="product-block__title-ico">
                <svg width="40" height="40">
                    <use xlink:href="#ico-menu-01"/>
                </svg>
            </div>
            <h2 class="product-block__title-main">
                <span class="product-block__title-name">Наборы</span>
            </h2>
        </div>
    </div>
    <div class="product-block__body product-set">
        <?php foreach ($products as $product): ?>
            <div class="product-set__item" data-base='<?= json_encode($product) ?>'>
                <div class="product-set__img js-buy">
                    <img src="<?= $product['img'] ?>" width="340" height="250" alt="">
                </div>
                <div class="product-set__inner">
                    <div class="product-set__title js-buy">
                        <span class="product-set__title-name"><?= $product['name'] ?></span>
                        <span class="product-set__title-weight"><?= $product['weight'] ?>г</span>
                    </div>
                    <!--noindex--><div class="product-set__desc"><?= $product['desc'] ?></div><!--/noindex-->
                    <div class="product-set__group">
                        <div class="product-set__price">
                            <div class="product-set__price-current"><?= number_format($product['price'], 0, ',', ' '); ?>₽</div>
                            <?php if ($product['old_price']): ?>
                                <div class="product-set__price-old"><?= number_format($product['old_price'], 0, ',', ' '); ?>₽</div>
                            <?php endif; ?>
                        </div>
                        <div class="product-set__buy btn js-buy">Оформить заказ</div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</section>