<?php
$meta_title = 'Паюсная черная икра';
$meta_description = ''; // можно оставить пустым
$canonical = ''; // можно оставить пустым
$theme = 'dark'; // dark или light
$filter = true;

require_once 'parts/header.php';
?>

    <div class="welcome">
        <div class="container welcome__container">

            <?php require 'parts/header-inner.php'; ?>

            <?php
                $welcome_product = [
                    'name' => 'Астраханская паюсная черная икра',
                    'weight' => 250,
                    'price' => 18990,
                    'old_price' => 20990,
                    'desc' => '<b>Состав:</b> икра осетровых рыб, соль.',
                    'label' => '',
                    'img' => '',
                    'gallery' => [
                        '/img/product/430x330/paus250.jpg',
                        '/img/product/430x330/paus1.jpg',
                        '/img/product/430x330/paus2.jpg',
                        '/img/product/430x330/paus3.jpg',
                        '/img/product/430x330/paus4.jpg',
                        '/img/product/430x330/sert1.jpg',
                        '/img/product/430x330/sert2.jpg',
                    ],
                    'review' => [
                        '/img/reviews/paus1.jpg',
                        '/img/reviews/paus2.jpg',
                        '/img/reviews/paus3.jpg',
                        '/img/reviews/paus4.jpg',
                    ],
                ];
            ?>

            <div class="dark-welcome dark-welcome_no-title" data-base='<?= json_encode($welcome_product) ?>'>
                <div class="dark-welcome__row">
                    <div class="dark-welcome__img">
                        <div class="dark-welcome__img-inner">
                            <img src="/img/welcome/img-welcome-paus250.png" width="782" height="547" alt="">
                        </div>
                    </div>
                    <div class="dark-welcome__about">
                        <div class="dark-welcome__name">Астраханская паюсная черная икра 250г</div>
                        <div class="dark-welcome__desc">По специальной цене</div>
                        <div class="dark-welcome__price">
                            <div class="dark-welcome__price-current">18 990 ₽</div>
                            <div class="dark-welcome__price-old">20 990 ₽</div>
                        </div>
                        <div class="dark-welcome__action">
                            <div class="dark-welcome__btn btn js-buy">Заказать со скидкой</div>
                            <div class="dark-welcome__date">Только до <?= get_future_date('next sunday') ?></div>
                        </div>
                    </div>
                </div>
                <div class="dark-welcome__advant">
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-map"/></svg>
                        <div class="dark-welcome__advant-title">Прямые поставки <br>из Астрахани</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-delivery"/></svg>
                        <div class="dark-welcome__advant-title">Бесплатная <br>доставка от 3 часов</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-menu-01"/></svg>
                        <div class="dark-welcome__advant-title">Без <br>консервантов</div>
                    </div>
                    <div class="dark-welcome__advant-item">
                        <svg class="dark-welcome__advant-ico"><use xlink:href="#ico-advant-caviar"/></svg>
                        <div class="dark-welcome__advant-title">Настоящий <br>малосол</div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="product-wrap">
        <div class="container">

            <div class="product-head" id="catalog">
                <div class="product-head__label">Широкий ассортимент</div>
                <div class="product-head__title">Фермерская икра</div>
            </div>

            <?php if (isset($filter) && $filter) { require 'parts/filter.php'; } ?>

            <div id="products">
                <?php require 'parts/product-classic.php'; ?>
                <?php require 'parts/product-carskaya.php'; ?>
                <?php require 'parts/product-premium.php'; ?>
                <?php require 'parts/product-royal.php'; ?>
                <?php require 'parts/product-paus.php'; ?>
                <?php require 'parts/product-royalpaus.php'; ?>
                <?php require 'parts/product-delicacy.php'; ?>
            </div>

        </div>
    </div>

<?php require 'parts/about.php'; ?>
<?php require 'parts/why.php'; ?>

<div class="bg-wrap">
    <div class="container">
        <?php require 'parts/review.php'; ?>
        <?php require 'parts/video.php'; ?>
    </div>
</div>

<?php require 'parts/certificate.php'; ?>
<?php require 'parts/delivery.php'; ?>

<?php require_once 'parts/footer.php'; ?>