<?php
$meta_title = 'Черная икра осетра Премиум 250г по специальной цене';
$meta_description = ''; // можно оставить пустым
$canonical = ''; // можно оставить пустым
$theme = 'light'; // dark или light
$filter = true;

require_once 'parts/header.php';
?>

    <div class="welcome">
        <div class="container welcome__container">

            <?php require 'parts/header-inner.php'; ?>

            <?php
            $welcome_product = [
                'name' => 'Икра черная "Премиум"',
                'weight' => 250,
                'price' => 11790,
                'old_price' => 14790,
                'desc' => '<b>Состав:</b> икра осетра, соль.',
                'label' => 'Хит продаж',
                'img' => '',
                'gallery' => [
                    '/img/product/430x330/prem250.jpg',
                    '/img/product/430x330/prem1.jpg',
                    '/img/product/430x330/prem2.jpg',
                    '/img/product/430x330/prem3.jpg',
                    '/img/product/430x330/prem4.jpg',
                    '/img/product/430x330/sert1.jpg',
                    '/img/product/430x330/sert2.jpg',
                ],
                'review' => [
                    '/img/reviews/premium1.jpg',
                    '/img/reviews/premium2.jpg',
                    '/img/reviews/premium3.jpg',
                    '/img/reviews/premium4.jpg',
                    '/img/reviews/premium5.jpg',
                ],
            ];
            ?>

            <div class="light-welcome light-welcome_lg-img light-welcome_premium" data-base='<?= json_encode($welcome_product) ?>'>
                <div class="light-welcome__mob">
                    <div class="light-welcome__name">
                        <div class="light-welcome__name-lg">СВЕЖАЙШАЯ <br>ИКРА ОСЕТРА</div>
                    </div>
                </div>
                <div class="light-welcome__row">
                    <div class="light-welcome__img">
                        <div class="light-welcome__img-inner">
                            <img src="/img/welcome/2-banki-100-premium.png" width="782" height="547" alt="">
                        </div>
                    </div>
                    <div class="light-welcome__about">
                        <div class="light-welcome__desk">
                            <div class="light-welcome__name">
                                <div class="light-welcome__name-sm">СВЕЖАЙШАЯ ИКРА ОСЕТРА</div>
                            </div>
                        </div>
                        <div class="light-welcome__date">Только до <?= get_future_date('next sunday') ?></div>
                        <div class="light-welcome__desc"><b>"ПРЕМИУМ" 250г</b><br>по специальной цене</div>
                        <div class="light-welcome__price">
                            <div class="light-welcome__price-current">11 790 ₽</div>
                            <div class="light-welcome__price-old">14 790 ₽</div>
                        </div>
                        <div class="light-welcome__action">
                            <div class="light-welcome__btn btn js-buy">Заказать со скидкой</div>

                            <div class="light-welcome__amount">Осталось <?= get_banks_left() ?> банок</div>
                        </div>
                    </div>
                </div>
                <div class="light-welcome__advant">
                    <div class="light-welcome__advant-item">
                        <svg class="light-welcome__advant-ico"><use xlink:href="#ico-menu-01"/></svg>
                        <div class="light-welcome__advant-title">Без консервантов - <br>Только Икра и соль</div>
                    </div>
                    <div class="light-welcome__advant-item">
                        <svg class="light-welcome__advant-ico"><use xlink:href="#ico-advant-map"/></svg>
                        <div class="light-welcome__advant-title">Производство в <br>Астрахани</div>
                    </div>
                    <div class="light-welcome__advant-item">
                        <svg class="light-welcome__advant-ico"><use xlink:href="#ico-advant-caviar"/></svg>
                        <div class="light-welcome__advant-title">Легальна и <br>сертифицирована</div>
                    </div>
                    <div class="light-welcome__advant-item">
                        <svg class="light-welcome__advant-ico"><use xlink:href="#ico-advant-delivery"/></svg>
                        <div class="light-welcome__advant-title">Бесплатная <br>доставка по <br>Москве</div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="product-wrap">
        <div class="container">

            <div class="product-head" id="catalog">
                <div class="product-head__label">Широкий ассортимент</div>
                <div class="product-head__title">Фермерская икра</div>
            </div>

            <?php if (isset($filter) && $filter) { require 'parts/filter.php'; } ?>

            <div id="products">
                <?php require 'parts/product-classic.php'; ?>
                <?php require 'parts/product-premium.php'; ?>
                <?php require 'parts/product-carskaya.php'; ?>
                <?php require 'parts/product-paus.php'; ?>
                <div class="product-head">
                    <div class="product-head__title">Икра мировых брендов</div>
                </div>
                <?php require 'parts/product-beluga.php'; ?>
                <?php require 'parts/product-delicacy.php'; ?>
            </div>

        </div>
    </div>

<?php require 'parts/about.php'; ?>
<?php require 'parts/why.php'; ?>

    <div class="bg-wrap">
        <div class="container">
            <?php require 'parts/review.php'; ?>
            <?php require 'parts/video.php'; ?>
        </div>
    </div>

<?php require 'parts/certificate.php'; ?>
<?php require 'parts/delivery.php'; ?>

<?php require_once 'parts/footer.php'; ?>