jQuery(function ($) {
    $('#add-new-form').on('click', addNewForm)
    $(document).on('click', '.r-btn-add-fields', addFormNewField)
    $(document).on('click', '.r-remove-btn button', removeFormBlock)
    $(document).on('click', '.field-remove', removeField)

    function removeField(e)
    {
        if(confirm('Вы уверены?')) {
            const removeBlock = $(this).parent().parent()
            removeBlock.remove()
        }
    }

    function removeFormBlock(e)
    {
        if(confirm('Вы уверены?')) {
            const removeBlock = $(this).parent().parent()
            removeBlock.remove()
        }
    }

    function formNewField(number)
    {
        const field = `
            <div class="r-form-fields">
                <div class="r-fields-title">
                    <input name="fields[key][]" type="text" id="fields[key][]" placeholder="Ключ" value="" class="regular-text">
                </div>
                <div class="r-inp">
                    <input name="fields[value][]" type="text" id="fields[value][]" placeholder="значение" value="" class="regular-text">
                    <button type="button" class="page-title-action r-red-color field-remove">Удалить</button>
                </div>
            </div>
        `
        $(`.field-block-${number}`).append(field)
    }

    function addFormNewField(e)
    {
        const dataNumber = $(this).data('number')
        formNewField(dataNumber)
    }

    function newForm()
    {
        const arrNum = $('.block-integration-form').length
        const form = `
            <div class="block-integration-form">
                <div class="r-remove-btn">
                    <button type="button" class="page-title-action r-red-color">Удалить</button>
                </div>
                        
                <div class="r-form">
                    <div class="r-field-title">
                        <label for="r-wp[${arrNum}][id]">ID формы</label>
                    </div>
                    <div class="r-inp">
                        <input name="r-wp[${arrNum}][id]" type="text" id="r-wp[${arrNum}][id]" value="" class="regular-text">
                    </div>
                </div>
                <div class="r-form">
                    <div class="r-field-title">
                        <label for="r-wp[${arrNum}][name]">Имя</label>
                    </div>
                    <div class="r-inp">
                        <input name="r-wp[${arrNum}][name]" type="text" id="r-wp[${arrNum}][name]" value="" class="regular-text">
                    </div>
                </div>
                <div class="r-form">
                    <div class="r-field-title">
                        <label for="r-wp[${arrNum}][phone]">Телефон</label>
                    </div>
                    <div class="r-inp">
                        <input name="r-wp[${arrNum}][phone]" type="text" id="r-wp[${arrNum}][phone]" value="" class="regular-text">
                    </div>
                </div>
                <div class="r-form">
                    <div class="r-field-title">
                        <label for="r-wp[${arrNum}][email]">Email</label>
                    </div>
                    <div class="r-inp">
                        <input name="r-wp[${arrNum}][email]" type="text" id="r-wp[${arrNum}][email]" value="" class="regular-text">
                    </div>
                </div>
                <div class="r-form">
                    <div class="r-field-title">
                        <label for="r-wp[${arrNum}][formname]">Название формы</label>
                    </div>
                    <div class="r-inp">
                        <input name="r-wp[${arrNum}][formname]" type="text" id="r-wp[${arrNum}][formname]" value="" class="regular-text">
                    </div>
                </div> 
                <div class="r-form">
                    <div class="r-field-title">
                        <label for="r-wp[${arrNum}][comment]">Комментарий</label>
                    </div>
                    <div class="r-inp">
                        <textarea name="r-wp[${arrNum}][comment]" rows="3" class="r-large-comment">{{comment_field}}</textarea>
                    </div>
                </div>
            </div>
        `;
        $('.r-wp-form .r-wp-form-block').append(form)
    }

    function addNewForm(e)
    {
        newForm()
    }
})