<?php

function getGeneralSettings()
{
    if(is_file(__DIR__ . '/../wp-general-settings.json')) {
        $json = file_get_contents(__DIR__ . '/../wp-general-settings.json');
        if(!empty($json)) {
            $json = json_decode($json, true);
            return $json['r-general'];
        }
    }
    return [];
}

/**
 * Сохранение данных в JSON файле
 * @param $data
 */
function setGeneralSettings($data)
{
    if(isset($_SESSION['roistat'])) {
        unset($_SESSION['roistat']);
    }

    file_put_contents(
        __DIR__ . '/../wp-general-settings.json',
        json_encode($data)
    );
    $_SESSION['roistat']['success'] = "Настройки успешно сохранены";
}

add_action( 'admin_init', 'stp_roistat_settings_init' );
function stp_api_add_admin_menu(  ) {
    add_options_page( 'Settings API Page', 'Settings API Page', 'manage_options', 'settings-api-page', 'stp_api_options_page' );
}

function stp_roistat_settings_init(  ) {
    register_setting( 'stpPlugin', 'roistat_settings' );
    add_settings_section(
        'stp_roistat_section',
        'Настройка интеграции',
        'stp_api_settings_section_callback',
        'stpPlugin'
    );
    add_settings_field(
        'key',
        'Ключ интеграции',
        'stp_roistat_key',
        'stpPlugin',
        'stp_roistat_section'
    );
    add_settings_field(
        'is_skip_sending',
        'Не отправлять в CRM',
        'stp_roistat_is_skip_sending',
        'stpPlugin',
        'stp_roistat_section'
    );
    add_settings_field(
        'counter',
        'Код счетчика',
        'stp_roistat_counter',
        'stpPlugin',
        'stp_roistat_section'
    );
}

/**
 * Поле Ключ интеграции
 */
function stp_roistat_key(  ) {
    $options = get_option( 'roistat_settings' );
?>
    <input type='text' class="regular-text" name='roistat_settings[key]' value='<?php echo $options['key']; ?>'>
<?php
}

/**
 * Поле Не отправлять в СРМ
 */
function stp_roistat_is_skip_sending(  ) {
    $options = get_option( 'roistat_settings' );
?>
    <input type="checkbox" id="roistat_settings" name="roistat_settings[is_skip_sending]" value="1" <?php checked(1, $options['is_skip_sending'], true); ?>/>
<?php
}

/**
 * Поле счетчика
 */
function stp_roistat_counter()
{
    $options = get_option( 'roistat_settings' );
?>
    <textarea name="roistat_settings[counter]" id="roistat_settings[counter]" rows="5" class="r-large-comment"><?= $options['counter']?></textarea>
<?php
}

function stp_api_settings_section_callback() {}

/**
 * Форма настроек
 */
function stp_api_options_page(  ) {
?>
    <form action='options.php' method='post'>
        <?php
            settings_fields( 'stpPlugin' );
            do_settings_sections( 'stpPlugin' );
            submit_button();
        ?>
    </form>
<?php
}

/**
 * Устаревший вариант. Можно даже удалить.
 */
function roistatSaveGeneralData()
{
    if(empty($_POST['r-general']['key'])) {
        $_SESSION['roistat']['errors'] = "Ключ интеграции обязателен";
        return;
    }
    setGeneralSettings($_POST);
}

/**
 * Добавление счетчика на сайт
 */
add_action( 'wp_footer', 'action_add_roistat_counter' );
function action_add_roistat_counter()
{
    $options = get_option( 'roistat_settings' );
    if(!empty($options['counter'])) {
        echo $options['counter'];
    }
}