<?php
/**
 * Отправить в ройстат
 * @param $formName
 */
function sendToRoistat($roistatData)
{
    if(empty($roistatData)) return false;

    $settings = get_option( 'roistat_settings' );
    if(  (empty($settings) && empty($settings['key'])) ||
        (empty($roistatData['phone']) && empty($roistatData['email']))
    ) return false;

    $roistatData = array_merge($roistatData, [
        'roistat' => isset($_COOKIE['roistat_visit']) ? $_COOKIE['roistat_visit'] : 'nocookie',
        'key' => $settings['key'],
        'title' => !empty($roistatData['title']) ? $roistatData['title'] : 'Заявка с сайта {domain}',
        'is_skip_sending' => !empty($settings['is_skip_sending']) ? 1 : 0
    ]);
    
    return file_get_contents('https://cloud.roistat.com/api/proxy/1.0/leads/add?' . http_build_query($roistatData, null, '&'));
}