<?php
/**
 * Событие при отправке формы с Wp Contact 7
 * @param $WPCF7_ContactForm
 */
function catchActionWpContact($WPCF7_ContactForm)
{
    $getFormItems = getContactFormItemsFromJsonFile();
    if(empty($getFormItems)) return;
    $formId     = $WPCF7_ContactForm->id();
    $formName   = $WPCF7_ContactForm->title();
    $submission = WPCF7_Submission::get_instance();
    if ($submission !== null) {
        $posted_data = $submission->get_posted_data();
        if (!empty($posted_data)) {
            if(!array_key_exists($formId, $getFormItems['items'])) return false;
            $formSettings = $getFormItems['items'][$formId];

            $roistatData['name']   = array_key_exists($formSettings['name'], $posted_data)  ? $posted_data[$formSettings['name']]  : null;
            $roistatData['phone']  = array_key_exists($formSettings['phone'], $posted_data) ? $posted_data[$formSettings['phone']] : null;
            $roistatData['email']  = array_key_exists($formSettings['email'], $posted_data) ? $posted_data[$formSettings['email']] : null;

            //Замена комментарии
            $comment = '';
            if(preg_match_all('|{{(.*)}}|Uis', $formSettings['comment'], $result)) {
                $comment = $formSettings['comment'];
                foreach ($result[1] as $key => $item) {
                    if(array_key_exists($item, $posted_data)) {
                        $field = is_array($posted_data[$item])
                                    ? implode(', ', $posted_data[$item])
                                    : $posted_data[$item];
                        $comment = str_replace($result[0][$key], $field, $comment);
                    }
                }
            }

            $roistatData['comment'] = $comment;

            $rFormName = !empty($formSettings['formname']) ? $formSettings['formname'] : $formName;
            //Замена доп.полей
            if(!empty($getFormItems['fields']) && count($getFormItems['fields']) > 0) {
                $fieldsList = [];
                foreach ($getFormItems['fields'] as $key => $val) {
                    if(preg_match_all('|{{(.*)}}|Uis', $val, $result)) {
                        if(array_key_exists($result[1][0], $posted_data)){
                            $fieldsList[$key] = $posted_data[$result[1][0]];
                        }
                    }
                    if($val == '{{formname}}') {
                        $fieldsList[$key] = $rFormName;
                    }
                }
                $roistatData['fields'] = $fieldsList + $getFormItems['fields'];
            }

            //Замена названии заявки
            if(!empty($getFormItems['title'])) {
                if(preg_match_all('|{{(.*)}}|Uis', $getFormItems['title'], $result)) {
                    if($result[1][0] === 'formname') {
                        $roistatData['title'] = str_replace($result[0][0], $rFormName, $getFormItems['title']);
                    } else {
                        $roistatData['title'] = $getFormItems['title']; 
                    }
                } else {
                    $roistatData['title'] = $getFormItems['title'];
                }
            }
            return sendToRoistat($roistatData);
        }
    }
    return true;
}
add_action("wpcf7_before_send_mail", "catchActionWpContact");