<?php
$formItems = getWooCommerceItemsFromJsonFile();
?>
<div class="r-row">
    <div class="col-md-8">
        <form action="" method="post">
            <div class="r-form">
                <div class="r-field-title">
                    <label for="woocommerce[title]">Название заявки</label>
                </div>
                <div class="r-inp">
                    <input name="woocommerce[title]" type="text" id="woocommerce[title]" value="Заявка из корзины" class="regular-text"
                    value="<?= !empty($formItems['title']) ? $formItems['title'] : ''?>">
                </div>
            </div>
            <div class="r-form">
                <div class="r-field-title">
                    <label for="woocommerce[comment]">Комментарий</label>
                </div>
                <div class="r-inp">
                    <?php
                        $comment = "Сумма заказа: {{price}}\r\n";
                        $comment .= "Доставка: {{shipping}}\r\n";
                        $comment .= "Способ оплаты: {{payment}}\r\n";
                        $comment .= "Товар: {{products}}\r\n";
                        $comment .= "Адрес: {{address}}";
                        if(!empty($formItems['comment'])) {
                            $comment = $formItems['comment'];
                        }
                    ?>

                    <textarea name="woocommerce[comment]" rows="3" class="r-large-comment"><?= $comment?></textarea>
                </div>
            </div>
            <div class="r-fields-block field-block-0">
                <h3 class="">Доп.поля</h3>
                <?php if(!empty($formItems['fields'])) : ?>
                    <?php foreach ($formItems['fields'] as $key => $formItem) : ?>
                        <div class="r-form-fields">
                            <div class="r-fields-title">
                                <input name="fields[key][]" type="text" id="fields[key][]" placeholder="Ключ" value="<?= $key?>" class="regular-text">
                            </div>
                            <div class="r-inp">
                                <input name="fields[value][]" type="text" id="fields[value][]" placeholder="значение" value="<?= $formItem?>" class="regular-text">
                                <button type="button" class="page-title-action r-red-color field-remove">Удалить</button>
                            </div>
                        </div>
                    <?php endforeach ?>
                <?php else: ?>
                    <div class="r-form-fields">
                        <div class="r-fields-title">
                            <input name="fields[key][]" type="text" id="fields[key][]" placeholder="Ключ" value="Название формы(заменить на ID из срм)" class="regular-text">
                        </div>
                        <div class="r-inp">
                            <input name="fields[value][]" type="text" id="fields[value][]" placeholder="значение" value="{{formname}}" class="regular-text">
                            <button type="button" class="page-title-action r-red-color field-remove">Удалить</button>
                        </div>
                    </div>
                <?php endif ?>
            </div>

            <div class="r-add-fields">
                <button type="button" class="hide-if-no-js r-btn-add-fields" data-number="0">
                    <i class="dashicons-before dashicons-plus"></i> Добавить доп.поле
                </button>
            </div>

            <?php
                wp_nonce_field( 'roistat-woocommerce-save', 'roistat-woocommerce-message' );
                submit_button();
            ?>

        </form>
    </div>
    <div class="col-md-4">
        <h4>Инструкция</h4>

        <h5>Доп.поля</h5>
        <p><b>{{price}}</b> - Цена </p>
        <p><b>{{shipping}}</b> - Доставка</p>
        <p><b>{{payment}}</b> - Оплата</p>
        <p><b>{{postcode}}</b> - Почтовый индекс</p>
        <p><b>{{address}}</b> - Адресс доставки</p>
        <p><b>{{products}}</b> - Товар</p>

        <h3>Поля можно добавить в комментарий </h3>
        <p>
            Сумма заказа: {{price}} <br>
            Доставка: {{shipping}}<br>
            Способ оплаты: {{payment}}<br>
            Товар: {{products}}<br>
            Адрес: {{address}}<br>
        </p>
    </div>

</div>