
(function ($) {
	'use strict';

	$(document).ready(function () {

		jQuery('.wpgs img').removeAttr('srcset');

		$('.woocommerce-product-gallery__image img').load(function () {

			var imageObj = $('.woocommerce-product-gallery__image img');

			if (!(imageObj.width() == 1 && imageObj.height() == 1)) {

				$('.wpgs-thumb-main-image').attr('src', imageObj.attr('src'));
				$('.wpgs-thumb-main-image').trigger('click');

			}
		});

		// Check if have Fancybox
		if (typeof $.fn.fancybox == 'function') {
			// Customize icons

			$.fancybox.defaults = $.extend(true, {}, $.fancybox.defaults, {

				thumbs: false

			});

			var selector = '.wpgs .slick-slide:not(.slick-cloned) a';

			// Skip cloned elements
			$().fancybox({
				selector: selector,
				backFocus: false
			});

			// Attach custom click event on cloned elements, 
			// trigger click event on corresponding link
			$(document).on('click', '.slick-cloned a', function (e) {
				$(selector)
					.eq(($(e.currentTarget).attr("data-slick-index") || 0) % $(selector).length)
					.trigger("click.fb-start", {
						$trigger: $(this)
					});
				return false;
			});
		}
		function ZoomIconApperce() {
			setTimeout(function () {
				$('.wpgs-lightbox-icon').css({ "position": "relative" });

			}, 500);

		}

		// On swipe event
		$('.wpgs-for').on('swipe', function (event, slick, direction) {
			$('.wpgs-lightbox-icon').css({ "position": "static" });
			ZoomIconApperce();
		});
		// On edge hit
		$('.wpgs-for').on('afterChange', function (event, slick, direction) {
			ZoomIconApperce();
		});
		$('.wpgs-for,.wpgs-nav').on('click', '.slick-arrow ,.slick-dots', function () {
			$('.wpgs-lightbox-icon').css({ "position": "static" });
			ZoomIconApperce();
		});
		$('.wpgs-nav').on('click', '.slick-slide', function () {
			$('.wpgs-lightbox-icon').css({ "position": "static" });
			ZoomIconApperce();
		});
		$('.wpgs-for').on('init', function (event, slick) {
			ZoomIconApperce();
		});
		if (typeof $.fn.zoom == 'function') {
			$('.wpgs-for img').each(function () {
				$(this).wrap("<div class='zoomtoo-container' data-zoom-image=" + $(this).data("zoom_src") + "></div>");
			});
			// var imgUrl = $(this).data("zoom-image");
			$('.zoomtoo-container').zoom({

				// Set zoom level from 1 to 5.
				magnify: 1,
				// Set what triggers the zoom. You can choose mouseover, click, grab, toggle.
				on: 'mouseover',
			})
		};

	});

})(jQuery);

// Other code using $ as an alias to the other library
