<?php
/**
 * Функции шаблона (function.php)
 */

function typical_title() { // функция вывода тайтла
	global $page, $paged; // переменные пагинации должны быть глобыльными
	wp_title('|', true, 'right'); // вывод стандартного заголовка с разделителем "|"
	bloginfo('name'); // вывод названия сайта
	$site_description = get_bloginfo('description', 'display'); // получаем описание сайта
	if ($site_description && (is_home() || is_front_page())) //если описание сайта есть и мы на главной
		echo " | $site_description"; // выводим описание сайта с "|" разделителем
	if ($paged >= 2 || $page >= 2) // если пагинация была использована
		echo ' | '.sprintf(__( 'Страница %s'), max($paged, $page)); // покажем номер страницы с "|" разделителем
}

register_nav_menus(array( // Регистрируем 2 меню
	'top' => 'Верхнее', // Верхнее
	'bottom' => 'Внизу' // Внизу
));

add_theme_support('post-thumbnails'); // включаем поддержку миниатюр
set_post_thumbnail_size(250, 150); // задаем размер миниатюрам 250x150
add_image_size('big-thumb', 400, 400, true); // добавляем еще один размер картинкам 400x400 с обрезкой

register_sidebar(array( // регистрируем левую колонку, этот кусок можно повторять для добавления новых областей для виджитов
	'name' => 'Колонка слева', // Название в админке
	'id' => "left-sidebar", // идентификатор для вызова в шаблонах
	'description' => 'Обычная колонка в сайдбаре', // Описалово в админке
	'before_widget' => '<div id="%1$s" class="widget %2$s">', // разметка до вывода каждого виджета
	'after_widget' => "</div>\n", // разметка после вывода каждого виджета
	'before_title' => '<span class="widgettitle">', //  разметка до вывода заголовка виджета
	'after_title' => "</span>\n", //  разметка после вывода заголовка виджета
));

class clean_comments_constructor extends Walker_Comment { // класс, который собирает всю структуру комментов
	public function start_lvl( &$output, $depth = 0, $args = array()) { // что выводим перед дочерними комментариями
		$output .= '<ul class="children">' . "\n";
	}
	public function end_lvl( &$output, $depth = 0, $args = array()) { // что выводим после дочерних комментариев
		$output .= "</ul><!-- .children -->\n";
	}
    protected function comment( $comment, $depth, $args ) { // разметка каждого комментария, без закрывающего </li>!
    	$classes = implode(' ', get_comment_class()).($comment->comment_author_email == get_the_author_meta('email') ? ' author-comment' : ''); // берем стандартные классы комментария и если коммент пренадлежит автору поста добавляем класс author-comment
        echo '<li id="li-comment-'.get_comment_ID().'" class="'.$classes.'">'."\n"; // родительский тэг комментария с классами выше и уникальным id
    	echo '<div id="comment-'.get_comment_ID().'">'."\n"; // элемент с таким id нужен для якорных ссылок на коммент
    	echo get_avatar($comment, 64)."\n"; // покажем аватар с размером 64х64
    	echo '<p class="meta">Автор: '.get_comment_author()."\n"; // имя автора коммента
    	echo ' '.get_comment_author_email(); // email автора коммента
    	echo ' '.get_comment_author_url(); // url автора коммента
    	echo ' Добавлено '.get_comment_date('F j, Y').' в '.get_comment_time()."\n"; // дата и время комментирования
    	if ( '0' == $comment->comment_approved ) echo '<em class="comment-awaiting-moderation">Ваш комментарий будет опубликован после проверки модератором.</em>'."\n"; // если комментарий должен пройти проверку
        comment_text()."\n"; // текст коммента
        $reply_link_args = array( // опции ссылки "ответить"
        	'depth' => $depth, // текущая вложенность
        	'reply_text' => 'Ответить', // текст
			'login_text' => 'Вы должны быть залогинены' // текст если юзер должен залогинеться
        );
        echo get_comment_reply_link(array_merge($args, $reply_link_args)); // выводим ссылку ответить
        echo '</div>'."\n"; // закрываем див
    }
    public function end_el( &$output, $comment, $depth = 0, $args = array() ) { // конец каждого коммента
		$output .= "</li><!-- #comment-## -->\n";
	}
}

function pagination() { // функция вывода пагинации
	global $wp_query; // текущая выборка должна быть глобальной
	$big = 999999999; // число для замены
	echo paginate_links(array( // вывод пагинации с опциями ниже
		'base' => str_replace($big,'%#%',esc_url(get_pagenum_link($big))), // что заменяем в формате ниже
		'format' => '?paged=%#%', // формат, %#% будет заменено
		'current' => max(1, get_query_var('paged')), // текущая страница, 1, если $_GET['page'] не определено
		'type' => 'list', // ссылки в ul
		'prev_text'    => 'Назад', // текст назад
    	'next_text'    => 'Вперед', // текст вперед
		'total' => $wp_query->max_num_pages, // общие кол-во страниц в пагинации
		'show_all'     => false, // не показывать ссылки на все страницы, иначе end_size и mid_size будут проигнорированны
		'end_size'     => 15, //  сколько страниц показать в начале и конце списка (12 ... 4 ... 89)
		'mid_size'     => 15, // сколько страниц показать вокруг текущей страницы (... 123 5 678 ...).
		'add_args'     => false, // массив GET параметров для добавления в ссылку страницы
		'add_fragment' => '',	// строка для добавления в конец ссылки на страницу
		'before_page_number' => '', // строка перед цифрой
		'after_page_number' => '' // строка после цифры
	));
}

add_filter( 'body_class','my_bodyclass_names' );
function my_bodyclass_names( $classes ) {
	
	if ( is_checkout() ) {
		
		$classes[] = 'woocommerce-cart';

	}
	
	if ( is_front_page() ) {
		
		$classes[] = 'theme-dark';

	} else {
		
		$classes[] = 'theme-light';
		
	}

	return $classes;
}

add_theme_support( 'woocommerce' );

add_action( 'wp_enqueue_scripts', 'jq_scripts_method' );
function jq_scripts_method(){
	wp_enqueue_script( 'commonjq', get_template_directory_uri() . '/js/common.js');
	wp_enqueue_script( 'slickjq', get_template_directory_uri() . '/js/slick.min.js');
	wp_enqueue_script( 'fancyboxjq', get_template_directory_uri() . '/js/jquery.fancybox.min.js');
}

add_action( 'wp_footer', 'cart_update_woos_script' );
function cart_update_woos_script() {
    if (is_cart()) :
    ?>
    <script>
        jQuery('div.woocommerce').on('change', '.qty', function(){
			jQuery("[name='update_cart']").removeAttr("disabled"); 
            jQuery("[name='update_cart']").trigger("click"); 
        });
    </script>
    <?php
    endif;
}

remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

add_filter('woocommerce_get_checkout_order_received_url','woo_order_received_url',0,2);
function woo_order_received_url($return_url,$order){
    $return_url = str_replace('order-received/','korzina/order-received/',$return_url);
	// удалить get запрос ?key=, т.к. он не дает добавить товары в корзину на странице благодарности
	$getz = mb_strstr($return_url,"?key=",true);
	if($getz) { 
		$return_url=$getz;
	}
    return $return_url;
}

function my_template_redirect(){
  if( is_404() && $_SERVER["REQUEST_URI"] != '/404/' ){
    wp_redirect( home_url( '/404/' ) );
    exit();
  }
  if (strpos($_SERVER['REQUEST_URI'], 'korzina/order-received') !== false) {
    wp_redirect( home_url( '/order-received/' ) );
    exit();	  
  }
}
add_action( 'template_redirect', 'my_template_redirect' );

// Маска ввода телефона на странице оформления
add_action('wp_enqueue_scripts', 'woo_maskedinput');
function woo_maskedinput() {
    if (is_checkout()) {
        wp_enqueue_script('maskedinput', '/wp-content/themes/ikra/js/jquery.maskedinput.js', array('jquery'));
        add_action( 'wp_footer', 'masked_script', 999);
    }
}
 function masked_script() {
    if ( wp_script_is( 'jquery', 'done' ) ) {
?>
    <script type="text/javascript">
        jQuery( function( $ ) {
            $("#billing_phone").mask("+7(999)999-99-99");
        });
    </script>
<?php
    }
}


add_action('wp_ajax_ql_woocommerce_ajax_add_to_cart', 'ql_woocommerce_ajax_add_to_cart'); 
add_action('wp_ajax_nopriv_ql_woocommerce_ajax_add_to_cart', 'ql_woocommerce_ajax_add_to_cart');          
function ql_woocommerce_ajax_add_to_cart() {  
    $product_id = apply_filters('ql_woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
    $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
    $variation_id = absint($_POST['variation_id']);
    $passed_validation = apply_filters('ql_woocommerce_add_to_cart_validation', true, $product_id, $quantity);
    $product_status = get_post_status($product_id); 
    if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) { 
        do_action('ql_woocommerce_ajax_added_to_cart', $product_id);
            if ('yes' === get_option('ql_woocommerce_cart_redirect_after_add')) { 
                wc_add_to_cart_message(array($product_id => $quantity), true); 
            } 
            WC_AJAX :: get_refreshed_fragments(); 
            } else { 
                $data = array( 
                    'error' => true,
                    'product_url' => apply_filters('ql_woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id));
                echo wp_send_json($data);
            }
            wp_die();
}


if ( ! function_exists( 'cart_link' ) ) {
	function cart_link() {
		?>
						<?php
							if (sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count ), WC()->cart->cart_contents_count ) == 0) {
						?>
					   <a href="<?php echo WC()->cart->get_cart_url() ?>" class="cart-contents" style="pointer-events: none">
					   <svg class="cart_svg"><use xlink:href="#ico-03"/></svg>
					   <div class="num_cart" style="background: #C0C3D2;">0</div>
					   <span>пока пусто</span>
					   </a>
						<?php } else { ?>
						<a href="<?php echo WC()->cart->get_cart_url() ?>" class="basket-btn basket-btn_fixed-xs cart-contents">
						   <svg class="cart_svg"><use xlink:href="#ico-03"/></svg>
						   <div class="num_cart basket-btn__counter"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count ), WC()->cart->cart_contents_count ); ?></div>
						   <span class="basket-btn__summa"><?php echo WC()->cart->get_cart_total(); ?></span>
						</a>	
						<?php } ?>
		<?php
	}
}

add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );

function woocommerce_header_add_to_cart_fragment( $fragments ) {
	ob_start();
	?>
						<?php
							if (sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count ), WC()->cart->cart_contents_count ) == 0) {
						?>
					   <a href="<?php echo WC()->cart->get_cart_url() ?>" class="cart-contents" style="pointer-events: none">
					   <svg class="cart_svg"><use xlink:href="#ico-03"/></svg>
					   <div class="num_cart" style="background: #C0C3D2;">0</div>
					   <span>пока пусто</span>
					   </a>
						<?php } else { ?>
						<a href="<?php echo WC()->cart->get_cart_url() ?>" class="basket-btn basket-btn_fixed-xs cart-contents">
						   <svg class="cart_svg"><use xlink:href="#ico-03"/></svg>
						   <div class="num_cart basket-btn__counter"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count ), WC()->cart->cart_contents_count ); ?></div>
						   <span class="basket-btn__summa"><?php echo WC()->cart->get_cart_total(); ?></span>
						</a>
						<?php } ?>
	<?php
	$fragments['a.cart-contents'] = ob_get_clean();
	return $fragments;
}
		
?>
