$(function () {
    /**
     * Отправка формы
     */

    let form, data;
    $(".send-data").submit(function (event) {
        form = $(this);
        data = form.serializeArray();
        data.push({name: "notspam", value: "1"});

        $.ajax({
            url: '/sendFormData.php',
            type: 'POST',
            data: data,
            success: function (data) {
                console.log(data);
                let inputPhone = form.find('input[type=tel]');

                if (data === 'success') {
                    window.location.href = "/succes.php";
                } else {
                    alert("Ошибка. Проверьте все поля формы и попробуйте еще раз!");
                }
            },
            error: function () {
                alert("Ошибка. Проверьте все поля формы и попробуйте еще раз!");
            }
        });
        event.preventDefault();
    });


    function phoneInputMask(selector) {
        let phoneInputs = document.querySelectorAll(selector);

        let getInputNumbersValue = function (input) {
            return input.value.replace(/\D/g, '');
        }

        let onPhonePaste = function (e) {
            let input = e.target,
                inputNumbersValue = getInputNumbersValue(input);
            let pasted = e.clipboardData || window.clipboardData;
            if (pasted) {
                let pastedText = pasted.getData('Text');
                if (/\D/g.test(pastedText)) {
                    input.value = inputNumbersValue;
                    return;
                }
            }
        }

        let onPhoneInput = function (e) {
            let input = e.target,
                inputNumbersValue = getInputNumbersValue(input),
                selectionStart = input.selectionStart,
                formattedInputValue = "";

            if (!inputNumbersValue) {
                return input.value = "";
            }

            if (input.value.length != selectionStart) {
                if (e.data && /\D/g.test(e.data)) {
                    input.value = inputNumbersValue;
                }
                return;
            }

            if (["7", "8"].indexOf(inputNumbersValue[0]) > -1) {
                let firstSymbols = (inputNumbersValue[0] == "8") ? "8" : "+7";
                formattedInputValue = input.value = firstSymbols + " ";
            } else {
                inputNumbersValue = "7" + inputNumbersValue;
                formattedInputValue = input.value = "+7 ";
            }

            if (inputNumbersValue.length > 1) {
                formattedInputValue += '(' + inputNumbersValue.substring(1, 4);
            }
            if (inputNumbersValue.length >= 5) {
                formattedInputValue += ') ' + inputNumbersValue.substring(4, 7);
            }
            if (inputNumbersValue.length >= 8) {
                formattedInputValue += '-' + inputNumbersValue.substring(7, 9);
            }
            if (inputNumbersValue.length >= 10) {
                formattedInputValue += '-' + inputNumbersValue.substring(9, 11);
            }

            input.value = formattedInputValue;
        }

        let onPhoneKeyDown = function (e) {
            let inputValue = e.target.value.replace(/\D/g, '');
            if (e.keyCode == 8 && inputValue.length == 1) {
                e.target.value = "";
            }
        }

        for (let phoneInput of phoneInputs) {
            phoneInput.addEventListener('keydown', onPhoneKeyDown);
            phoneInput.addEventListener('input', onPhoneInput, false);
            phoneInput.addEventListener('paste', onPhonePaste, false);
        }
    }

    phoneInputMask('input[type=tel]');

    $('.send-data .btn').click(function (e) {
        let input = $(this).parents('form').find('input[type=tel]');
        let value = input.val();
        let length = value.length;
        let maxLength = value[0] === '8' ? 17 : 18;

        if (length >= 1 && length < maxLength) {
            input.addClass('error-control');
            input.next('.error-message').text('Номер телефона введен не полностью').show();

            return false;
        } else if (length === 0) {
            input.addClass('error-control');
            input.next('.error-message').text('Не введен номер телефона').show();

            return false;
        }
    });

    $('.send-data').on('keyup', '.error-control', function () {
        let input = $(this);
        let value = input.val();
        let length = value.length;
        let maxLength = value[0] === '8' ? 17 : 18;

        if (value.length < maxLength) {
            $(input).next('.error-message').text('Номер телефона введен не полностью').show();
        } else {
            $(input).removeClass('error-control').next('.error-message').text('').hide();
        }
    });

});