<?php
/**
  * Template Name: Страница благодарности
 * Шаблон обычной страницы (page.php)
 */
get_header(); // подключаем header.php ?>
<?php if ( have_posts() ) while ( have_posts() ) : the_post(); // старт цикла ?>

	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>> <?php // контэйнер с классами и id ?>
	
    <div class="welcome ordr-received">
        <div class="container welcome__container">

            <?php require get_template_directory() . '/parts/header-inner.php'; ?>
			
            <div class="success-page">
                <div class="success-page__title">Благодарим за Заявку! <br>Ваша заявка принята и поставлена в обработку</div>
                <div class="success-page__product">
                    <div class="success-page__product-title">Попробуйте астраханскую рыбку из свежей партии</div>
                    <div class="success-page__product-list product-list">
                    <?php 
						
						$term_id = 27;
						
						$product_cat_name = get_term_by( 'ID', $term_id, 'product_cat' );
					
					?>
					
					<section class="product-block product-block_open product-block_style-2">
						
						<div class="product-block__body product-list">

						<?php
						
							$args = array(
								'orderby' => 'date',
								'posts_per_page' => -1,
								'post_type' => 'product',
								'product_cat' => $product_cat_name->slug,
							);

							$loop = new WP_Query( $args );
							while ( $loop->have_posts() ) : $loop->the_post();
							global $product;
								require get_template_directory() . '/parts/product-item.php';
							
							endwhile;
							wp_reset_query();
						
						?>
						
						</div>

					</section>
                    </div>
                </div>
                <div class="success-page__back">
                    <a href="/" class="success-page__back-link">Вернуться на главную</a>
                </div>
            </div>

        </div>
    </div>

	</article>
<?php endwhile; // конец цикла ?>
<?php get_footer(); // подключаем footer.php ?>