<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_cart' );

$gramm = 'г';

$tovark = 'товар';

 ?>

<?php if(!is_wc_endpoint_url( 'order-received' )){ ?>

     <div class="welcome">
        <div class="container welcome__container">

            <?php require get_template_directory() . '/parts/header-inner.php'; ?>
			
<div class="light-welcome light-welcome_lg-img light-welcome_premium">
                <div class="light-welcome__row">
                    <div class="light-welcome__about">
						<div class="welcome_desk__block">
                        <div class="light-welcome__desk">
                            <div class="light-welcome__name">
                                <h1 class="product_zag"><?php echo get_the_title(); ?>:</h1> <div class="num_incart"><?php echo count(WC()->cart->get_cart()); ?> <?php echo $tovark; ?></div>
                            </div>
                        </div>
						
<form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
	<?php do_action( 'woocommerce_before_cart_table' ); ?>
	
						<div class="light-welcome_priceact">
				<div class="popup popup-cart" id="popup-cart">

	<div class="shop_table shop_table_responsive cart woocommerce-cart-form__contents">

			<?php do_action( 'woocommerce_before_cart_contents' ); ?>

			<?php
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
				$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

				if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
					$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
					?>
								
				<div class="product-list__item product woocommerce-cart-form__cart-item cart_item <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
					<div class="product__img js-buy product-thumbnail">					
						<?php
						$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image('full'), $cart_item, $cart_item_key );

						if ( ! $product_permalink ) {
							echo $thumbnail; // PHPCS: XSS ok.
						} else {
							printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
						}
						?>
					</div>
					<div class="product__inner">
						<div class="product_title_name">
							<div class="product__title js-buy product-name" data-title="<?php esc_attr_e( 'Product', 'woocommerce' ); ?>">
								<a href="<?php echo $_product->get_permalink(); ?>" class="product__title" style="text-decoration: none;">
								<?php
								if ( ! $product_permalink ) {
									echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) . '&nbsp;' );
								} else {
									echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<span class="product__title-name" href="%s">%s</span>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
								}

								do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );

								?>
								</a>
								
							</div>
							<div class="product__price">
								<?php if ($_product->get_sale_price()) { ?>
								<div class="product__price-current product-price" data-title="<?php esc_attr_e( 'Price', 'woocommerce' ); ?>"><?php echo number_format($_product->get_sale_price(), 0, '', ' '); ?><?php echo get_woocommerce_currency_symbol(); ?></div>
								<div class="product__price-old"><?php echo number_format($_product->get_regular_price(), 0, '', ' '); ?><?php echo get_woocommerce_currency_symbol(); ?></div>
								<?php } else { ?>
								<div class="product__price-current"><?php echo number_format($_product->get_regular_price(), 0, '', ' '); ?><?php echo get_woocommerce_currency_symbol(); ?></div>							
								<?php } ?>
							</div>							
						</div>
						<div class="product_addtocart">
						<div class="popup-cart__amount-value">
							<div class="product-quantity" data-title="<?php esc_attr_e( 'Quantity', 'woocommerce' ); ?>">
							<?php
							if ( $_product->is_sold_individually() ) {
								$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
							} else {
								$product_quantity = woocommerce_quantity_input(
									array(
										'input_name'   => "cart[{$cart_item_key}][qty]",
										'input_value'  => $cart_item['quantity'],
										'max_value'    => $_product->get_max_purchase_quantity(),
										'min_value'    => '0',
										'product_name' => $_product->get_name(),
									),
									$_product,
									false
								);
							}

							echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
							?>
							</div>
						</div>
						<div class="product__buy btn js-buy" >
							<div class="product__price-current product-subtotal" data-title="<?php esc_attr_e( 'Subtotal', 'woocommerce' ); ?>">
								<?php
									echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
								?>
							</div>
						</div>
							<?php
								echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
									'woocommerce_cart_item_remove_link',
									sprintf(
										'<a href="%s" class="delcart-ico product-remove remove" aria-label="%s" data-product_id="%s" data-product_sku="%s"><svg width="13" height="16"><use xlink:href="#ico-delcart"/></svg></a>',
										esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
										esc_html__( 'Remove this item', 'woocommerce' ),
										esc_attr( $product_id ),
										esc_attr( $_product->get_sku() )
									),
									$cart_item_key
								);
							?>

						</div>
					</div>
				</div>
					
					<?php
				}
			}
			?>

			<?php do_action( 'woocommerce_cart_contents' ); ?>

			<tr>
				<td colspan="6" class="actions">

					<?php if ( wc_coupons_enabled() ) { ?>
						<div class="coupon">
							<label for="coupon_code"><?php esc_html_e( 'Coupon:', 'woocommerce' ); ?></label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" /> <button type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?></button>
							<?php do_action( 'woocommerce_cart_coupon' ); ?>
						</div>
					<?php } ?>

					<button type="submit" class="button" name="update_cart" value="<?php esc_attr_e( 'Update cart', 'woocommerce' ); ?>"><?php esc_html_e( 'Update cart', 'woocommerce' ); ?></button>

					<?php do_action( 'woocommerce_cart_actions' ); ?>

					<?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
				</td>
			</tr>

			<?php do_action( 'woocommerce_after_cart_contents' ); ?>

	</div>
				</div>	
						</div>	
	<?php do_action( 'woocommerce_after_cart_table' ); ?>
</form>

<?php do_action( 'woocommerce_before_cart_collaterals' ); ?>		

					

						
						<div class="product_cart_text cart-collaterals  cart_totals  ">
							<div class="price_incart"><?php wc_cart_totals_subtotal_html(); ?> <div class="dostavka_incart">итого без учета доставки</div></div>
						</div>
						<div class="">
							<div class="product-block__desc">Введите ваш номер телефона и менеджер свяжется с вами<br> для уточнения адреса и времени доставки</div>
						</div>
						</div>
                    </div>
                </div>
</div>


        </div>
    </div>
	
<?php } ?>
	
<?php do_action( 'woocommerce_after_cart' ); ?>

