<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>

<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>

            <div class="light-welcome light-welcome_lg-img light-welcome_premium">
                <div class="light-welcome__mob">
                    <div class="light-welcome__name">
						<div class="kroshki"><a href="/">Черная икра</a> - <?php echo get_the_title(); ?></div>
                        <div class="product_zag"><?php echo get_the_title(); ?></div>
						<div class="review_rat_ing"> <strong></strong></div>
                    </div>
                </div>
                <div class="light-welcome__row">
                    <div class="light-welcome__img">
					<?php do_action( 'woocommerce_before_single_product_summary' ); ?>
                    </div>
                    <div class="light-welcome__about">
						<img src="<?php echo get_template_directory_uri(); ?>/img/goods/fon_front6.png" class="fon_front6">
						<div class="welcome_desk__block">
                        <div class="light-welcome__desk">
                            <div class="light-welcome__name">
								<div class="kroshki"><a href="/">Черная икра</a> - <?php echo get_the_title(); ?></div>
                                <h1 class="product_zag"><?php echo get_the_title(); ?></h1>
								<div class="review_rat_ing"> <strong></strong></div>
                            </div>
                        </div>
						<div class="light-welcome_priceact">
							<div class="light-welcome__price">
								<?php if ($product->get_sale_price()) { ?>
								<div class="light-welcome__price-old"><?php echo number_format($product->get_regular_price(), 0, '', ' '); ?> <?php echo get_woocommerce_currency_symbol(); ?></div>
								<div class="light-welcome__price-current"><?php echo number_format($product->get_sale_price(), 0, '', ' '); ?><?php echo get_woocommerce_currency_symbol(); ?></div>
								<?php } else { ?>
								<div class="light-welcome__price-current"><?php echo number_format($product->get_regular_price(), 0, '', ' '); ?><?php echo get_woocommerce_currency_symbol(); ?></div>			
								<?php } ?>
							</div>
							<div class="light-welcome__action">
								<div class="product_addtocart">
									<?php woocommerce_template_single_add_to_cart(); ?>
					
								</div>
							</div>
						</div>
						<div class="light-welcome__advant">
							<div class="light-welcome__advant-item">
								<svg class="light-welcome__advant-ico"><use xlink:href="#ico-advant-map"/></svg>
								<div class="light-welcome__advant-title">Производство в <br>Астрахани</div>
							</div>
							<div class="light-welcome__advant-item">
								<svg class="light-welcome__advant-ico"><use xlink:href="#ico-advant-caviar"/></svg>
								<div class="light-welcome__advant-title">Легальна и <br>сертифицирована</div>
							</div>
							<div class="light-welcome__advant-item">
								<svg class="light-welcome__advant-ico"><use xlink:href="#ico-advant-delivery"/></svg>
								<div class="light-welcome__advant-title">Бесплатная <br>доставка по <br>Москве</div>
							</div>
						</div>
						<div class="product_page-text">
							<div class="product_page-opisanie">
							<strong>Описание:</strong>
							<?php the_content(); ?>
							</div>
							<div class="product_page-sostav"><strong>Состав:</strong> <?php if( get_field( "состав" ) ) { echo get_field( "состав" ); } ?></div>
							<div class="product_page-xranenie"><strong>Условия хранения:</strong> <?php if( get_field( "условия_хранения" ) ) { echo get_field( "условия_хранения" ); } ?></div>
						</div>
						</div>
                    </div>
                </div>
            </div>

</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
