<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>


    <div class="welcome">
        <div class="container welcome__container">

            <?php require get_template_directory() . '/parts/header-inner.php'; ?>
			
	<?php
		/**
		 * woocommerce_before_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		//do_action( 'woocommerce_before_main_content' );
	?>

		<?php while ( have_posts() ) : ?>
			<?php the_post(); ?>

			<?php wc_get_template_part( 'content', 'single-product' ); ?>

		<?php endwhile; // end of the loop. ?>

	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		//do_action( 'woocommerce_after_main_content' );
	?>

	<?php
		/**
		 * woocommerce_sidebar hook.
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		do_action( 'woocommerce_sidebar' );
	?>

        </div>
    </div>
	
	<div class="delivery" id="delivery">
		<div class="delivery__main">
			<div class="container">
				<div class="delivery_blok_title">
					<div class="delivery__title">Бесплатная доставка по Москве от 3 часов</div>
				</div>
				<div class="delivery__list">
					<div class="delivery__item">
						<div class="delivery__item-head">
							<div class="delivery__item-ico">
                            <svg width="60" height="60">
                                <use xlink:href="#ico-delivery-01"/>
                            </svg>
							</div>
							<div class="delivery__item-desc"><div class="delivery__item-title">Оплата</div><div>при получении Вашего заказа курьеру - наличными или картой. Никаких предоплат, вы ничем не рискуете!</div></div>
						</div>
					</div>
					<div class="delivery__item">
						<div class="delivery__item-head">
							<div class="delivery__item-ico">
                            <svg width="60" height="60">
                                <use xlink:href="#ico-delivery-02"/>
                            </svg>
							</div>
							<div class="delivery__item-desc"><div class="delivery__item-title">Доставка</div><div>курьером лично в руки. Бесплатно в пределах мкад от 5000р. За Мкад: 500р за каждые 10км.</div></div>
						</div>
					</div>
					<div class="delivery__item">
						<div class="delivery__item-head">
							<div class="delivery__item-ico">
                            <svg width="60" height="60">
                                <use xlink:href="#ico-delivery-03"/>
                            </svg>
							</div>
							<div class="delivery__item-desc"><div class="delivery__item-title">Бесплатно с каждым заказом</div><div>термопакет и хладокомпонент. Ваш заказ приедет к вам свежайшим и готовым к любым Вашим поездкам.</div></div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php if( have_rows('отзывы') ): ?>

	<div class="bg-wrap">
			<img class="fon_front8" src="<?php echo get_template_directory_uri(); ?>/img/goods/fon_front8.png">
			<div class="container">
				<div class="review" id="review">
					<div class="review__title">Отзывы наших клиентов</div>
					<div class="review__slider">
						<div class="carousel">

							<?php

								while ( have_rows('отзывы') ) : the_row();
									
									$sub_img = get_sub_field('фото_отзыва');

									if( !empty($sub_img) ) {
										
										echo '<div class="carousel__item"><a class="carousel__link" href="' . $sub_img['url'] . '" data-fancybox="review">';
										echo '<img src="' . $sub_img['url'] . '" alt="" />';
										echo '</a></div>';
									}

								endwhile;

							?>

						</div>
					</div>
				</div>
			</div>
	</div>
	
	<?php endif; ?>

<?php require get_template_directory() . '/parts/certificate.php'; ?>

<div id="products">
                
<section class="product-block product-block_open product-block_style-1">
<div class="container">
    <div class="product-block__head">
        <div class="product-block__title">
            <div class="product-block__title-ico">
                <svg width="40" height="40">
                    <use xlink:href="#ico-bpopul"></use>
                </svg>
            </div>
            <div class="product-block__title-main">
                <span class="product-block__title-name">Рекомендованные товары</span>
            </div>
        </div>
    </div>
    <div class="product-block__body product-list">

 		<?php

			echo do_shortcode('[product_category category="29" per_page="4"]');

		?>
		
    </div>
</div>
</section>   

</div>


<?php
get_footer( 'shop' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
